/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.ui.catalog.UserActionCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractUserActionItem;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDiscoveryResources;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RetryErrorActionItem
extends AbstractUserActionItem {
    private static final int RETRY_ACTION_ID = 1;
    private static final int DETAILS_ACTION_ID = 0;

    public RetryErrorActionItem(Composite parent, MarketplaceDiscoveryResources resources, UserActionCatalogItem connector, MarketplaceViewer viewer) {
        super(parent, resources, connector, viewer);
    }

    private IStatus getError() {
        return MarketplaceClientCore.computeStatus((Throwable)((Throwable)((UserActionCatalogItem)this.connector).getData()), null);
    }

    @Override
    protected String getNameLabelText() {
        return Messages.UserFavoritesUnsupportedActionItem_unsupportedFavoritesLabel;
    }

    @Override
    protected String getDescriptionText() {
        IStatus error = this.getError();
        return NLS.bind((String)Messages.RetryErrorActionItem_failedToLoadMessage, (Object)(error.getMessage() == null ? error.getClass().getSimpleName() : error.getMessage()));
    }

    @Override
    protected Icon getIcon() {
        String path = "registry:ACTION_ICON_WARNING";
        return RetryErrorActionItem.createIcon(path);
    }

    @Override
    protected String getSublineText() {
        return Messages.RetryErrorActionItem_subline;
    }

    @Override
    protected void createButtons(Composite parent) {
        this.createButton(parent, Messages.RetryErrorActionItem_showDetailsActionLabel, Messages.RetryErrorActionItem_showDetailsTooltip, 0);
        this.createButton(parent, Messages.RetryErrorActionItem_retryActionLabel, Messages.RetryErrorActionItem_retryTooltip, 1);
    }

    @Override
    protected void buttonPressed(int id) {
        if (id == 1) {
            this.retry();
        } else {
            this.showDetails();
        }
    }

    protected void showDetails() {
        IStatus error = this.getError();
        ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RetryErrorActionItem_errorDetailsDialogTitle, (String)this.getDescriptionText(), (IStatus)error);
    }

    protected void retry() {
        this.getViewer().reload();
    }

    @Override
    protected MarketplaceViewer getViewer() {
        return (MarketplaceViewer)super.getViewer();
    }
}

