/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.jpa2.context.DerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.GraphicalAddAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.UpdateAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IAddEntityContext;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.GraphicsUpdater;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorPredefinedColoredAreas;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.Wrp;

public class AddJPAEntityFeature
extends AbstractAddShapeFeature {
    private boolean shouldRearrangeIsARelations = true;
    private static ContainerShape primaryShape;
    private static ContainerShape relationShape;
    private static ContainerShape basicShape;

    public AddJPAEntityFeature(IFeatureProvider fp, boolean shouldRearrangeIsARelations) {
        super(fp);
        this.shouldRearrangeIsARelations = shouldRearrangeIsARelations;
    }

    public AddJPAEntityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        Object newObj = context.getNewObject();
        if (newObj instanceof PersistentType) {
            if (context.getTargetContainer() instanceof Diagram) {
                PersistentType jpt = (PersistentType)newObj;
                return this.checkJPTForAdding(jpt);
            }
        } else if (newObj instanceof ICompilationUnit && context.getTargetContainer() instanceof Diagram) {
            ICompilationUnit cu = (ICompilationUnit)newObj;
            PersistentType jpt = JPAEditorUtil.getJPType(cu);
            return this.checkJPTForAdding(jpt);
        }
        if (newObj instanceof SourceType && context.getTargetContainer() instanceof Diagram) {
            ICompilationUnit cu = ((SourceType)newObj).getCompilationUnit();
            PersistentType jpt = JPAEditorUtil.getJPType(cu);
            return this.checkJPTForAdding(jpt);
        }
        return false;
    }

    private boolean checkJPTForAdding(PersistentType jpt) {
        if (jpt == null) {
            return false;
        }
        PictogramElement[] pictograms = this.getFeatureProvider().getAllPictogramElementsForBusinessObject(jpt);
        JpaProject proj = ModelIntegrationUtil.getProjectByDiagram(this.getDiagram().getName());
        if (proj != null && proj != jpt.getJpaProject()) {
            return false;
        }
        return pictograms == null || pictograms.length == 0;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public PictogramElement add(IAddContext context) {
        ICompilationUnit cu;
        IJPAEditorFeatureProvider fp = this.getFeatureProvider();
        Object newObj = context.getNewObject();
        PersistentType jpt = null;
        if (newObj instanceof PersistentType) {
            jpt = (PersistentType)newObj;
        } else if (newObj instanceof ICompilationUnit) {
            cu = (ICompilationUnit)newObj;
            jpt = JPAEditorUtil.getJPType(cu);
        } else if (newObj instanceof SourceType) {
            cu = ((SourceType)newObj).getCompilationUnit();
            jpt = JPAEditorUtil.getJPType(cu);
        }
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        Wrp wrp = new Wrp();
        this.createEntity(context, fp, targetDiagram, wrp, jpt);
        return (PictogramElement)wrp.getObj();
    }

    private void createEntity(final IAddContext context, final IJPAEditorFeatureProvider fp, final Diagram targetDiagram, final Wrp wrp, final PersistentType jpt) {
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)targetDiagram);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                ContainerShape entityShape = Graphiti.getPeService().createContainerShape((ContainerShape)targetDiagram, true);
                JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot = JpaArtifactFactory.instance().determineDiagramObjectType(jpt);
                AddJPAEntityFeature.createEntityRectangle(context, entityShape, dot, fp.getDiagramTypeProvider().getDiagram());
                AddJPAEntityFeature.this.link((PictogramElement)entityShape, jpt);
                Shape shape = Graphiti.getPeService().createShape(entityShape, false);
                int[] nArray = new int[4];
                nArray[1] = 30;
                nArray[2] = 120;
                nArray[3] = 30;
                Polyline headerBottomLine = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)shape, nArray);
                headerBottomLine.setForeground(AddJPAEntityFeature.this.manageColor(JPAEditorConstants.ENTITY_BORDER_COLOR));
                headerBottomLine.setLineWidth(JPAEditorConstants.ENTITY_BORDER_WIDTH);
                AddJPAEntityFeature.this.addHeader(jpt, entityShape, 120, dot);
                AddJPAEntityFeature.this.createCompartments(context, jpt, entityShape);
                AddJPAEntityFeature.this.fillCompartments(jpt, entityShape);
                String key = fp.getKeyForBusinessObject(jpt);
                if (fp.getBusinessObjectForKey(key) == null) {
                    fp.putKeyToBusinessObject(key, jpt);
                }
                Graphiti.getPeService().createChopboxAnchor((AnchorContainer)entityShape);
                entityShape.setVisible(true);
                AddJPAEntityFeature.this.layoutPictogramElement((PictogramElement)entityShape);
                UpdateAttributeFeature updateFeature = new UpdateAttributeFeature(fp);
                updateFeature.reconnect(jpt);
                if (AddJPAEntityFeature.this.shouldRearrangeIsARelations) {
                    JpaArtifactFactory.instance().rearrangeIsARelations(AddJPAEntityFeature.this.getFeatureProvider());
                }
                wrp.setObj(entityShape);
            }
        });
    }

    private void createCompartments(IAddContext context, PersistentType jpt, ContainerShape entityShape) {
        JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot = JpaArtifactFactory.instance().determineDiagramObjectType(jpt);
        primaryShape = this.createCompartmentRectangle(entityShape, 30, JPAEditorMessages.AddJPAEntityFeature_primaryKeysShape, dot);
        relationShape = this.createCompartmentRectangle(entityShape, GraphicsUpdater.getNextCompartmentY(primaryShape) + 2, JPAEditorMessages.AddJPAEntityFeature_relationAttributesShapes, dot);
        basicShape = this.createCompartmentRectangle(entityShape, GraphicsUpdater.getNextCompartmentY(relationShape) + 2, JPAEditorMessages.AddJPAEntityFeature_basicAttributesShapes, dot);
        if (IAddEntityContext.class.isInstance(context)) {
            IAddEntityContext entityContext = (IAddEntityContext)context;
            GraphicsUpdater.setCollapsed(primaryShape, entityContext.isPrimaryCollapsed());
            GraphicsUpdater.setCollapsed(basicShape, entityContext.isBasicCollapsed());
            GraphicsUpdater.setCollapsed(relationShape, entityContext.isRelationCollapsed());
        } else {
            GraphicsUpdater.setCollapsed(primaryShape, false);
            GraphicsUpdater.setCollapsed(basicShape, false);
            GraphicsUpdater.setCollapsed(relationShape, false);
        }
    }

    private void fillCompartments(PersistentType jpt, ContainerShape entityShape) {
        String[] relationMappingKeys;
        String[] primaryMappingKeys;
        String[] stringArray = primaryMappingKeys = new String[]{"id", "embeddedId", "derived-id"};
        int n = primaryMappingKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String mappingKey = stringArray[n2];
            this.addCompartmentChildren(primaryShape, jpt, mappingKey);
            ++n2;
        }
        String[] stringArray2 = relationMappingKeys = new String[]{"oneToOne", "oneToMany", "manyToOne", "manyToMany"};
        int n3 = relationMappingKeys.length;
        n = 0;
        while (n < n3) {
            String mappingKey = stringArray2[n];
            this.addCompartmentChildren(relationShape, jpt, mappingKey);
            ++n;
        }
        this.addBasicAttributes(basicShape, jpt, Arrays.asList(primaryMappingKeys), Arrays.asList(relationMappingKeys));
        GraphicsUpdater.updateEntityShape(entityShape);
    }

    private String getMappingKey(PersistentAttribute attr) {
        DerivedIdentity2_0 identity;
        AttributeMapping attrMapping = JpaArtifactFactory.instance().getAttributeMapping(attr);
        if (attrMapping instanceof SingleRelationshipMapping2_0 && ((identity = ((SingleRelationshipMapping2_0)attrMapping).getDerivedIdentity()).usesIdDerivedIdentityStrategy() || identity.usesMapsIdDerivedIdentityStrategy())) {
            return "derived-id";
        }
        return attrMapping.getKey();
    }

    private ContainerShape createCompartmentRectangle(ContainerShape entityShape, int y, String attribTxt, JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot) {
        int width = entityShape.getGraphicsAlgorithm().getWidth();
        ContainerShape containerShape = Graphiti.getPeService().createContainerShape(entityShape, false);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, JPAEditorConstants.PROP_SHAPE_TYPE, JPAEditorConstants.ShapeType.COMPARTMENT.toString());
        Rectangle rect = this.addCompartmentRectangle(y, width, containerShape);
        this.addCompartmentHeaderText(attribTxt, width, rect);
        UpdateAttributeFeature updateFeature = new UpdateAttributeFeature(this.getFeatureProvider());
        updateFeature.addSeparatorsToShape(containerShape, dot);
        return containerShape;
    }

    private Rectangle addCompartmentRectangle(int y, int width, ContainerShape containerShape) {
        Rectangle rect = Graphiti.getGaService().createRectangle((GraphicsAlgorithmContainer)containerShape);
        rect.setFilled(Boolean.FALSE);
        rect.setLineVisible(Boolean.FALSE);
        rect.setHeight(0);
        rect.setWidth(width);
        rect.setX(0);
        rect.setY(y);
        containerShape.setActive(true);
        return rect;
    }

    private void addCompartmentHeaderText(String attribTxt, int width, Rectangle rect) {
        IJPAEditorFeatureProvider fp = this.getFeatureProvider();
        Text text = UpdateAttributeFeature.addText(fp, rect, attribTxt);
        Font font = GraphitiUi.getGaService().manageFont(this.getDiagram(), "Arial", 7, true, false);
        text.setFont(font);
        Graphiti.getGaService().setWidth((GraphicsAlgorithm)text, width);
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)text, 0, 2, width, 13);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
    }

    private void addCompartmentChildren(ContainerShape containerShape, PersistentType jpt, String attributeMappingKey) {
        ArrayList<PersistentAttribute> attributes = new ArrayList<PersistentAttribute>();
        for (PersistentAttribute attribute : jpt.getAttributes()) {
            String mappingKey = this.getMappingKey(attribute);
            if (!attributeMappingKey.equals(mappingKey)) continue;
            attributes.add(attribute);
        }
        this.addAttributes(containerShape, attributes);
    }

    private void addBasicAttributes(ContainerShape containerShape, PersistentType jpt, List<String> primaryKeyMappings, List<String> relationshipMappings) {
        ArrayList<PersistentAttribute> attributes = new ArrayList<PersistentAttribute>();
        for (PersistentAttribute attribute : jpt.getAttributes()) {
            String mappingKey = this.getMappingKey(attribute);
            if (primaryKeyMappings.contains(mappingKey) || relationshipMappings.contains(mappingKey)) continue;
            attributes.add(attribute);
        }
        this.addAttributes(containerShape, attributes);
    }

    private void addAttributes(ContainerShape entityShape, List<PersistentAttribute> attributes) {
        int i = 0;
        while (i < attributes.size()) {
            PersistentAttribute jpa = attributes.get(i);
            this.addAttribute(jpa, entityShape);
            ++i;
        }
    }

    public static RoundedRectangle createEntityRectangle(IAddContext context, ContainerShape entityShape, JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot, Diagram diagram) {
        IColorConstant foreground = JpaArtifactFactory.instance().getForeground(dot);
        IColorConstant background = JpaArtifactFactory.instance().getBackground(dot);
        String renderingStyle = JpaArtifactFactory.instance().getRenderingStyle(dot);
        RoundedRectangle entityRectangle = Graphiti.getGaService().createRoundedRectangle((GraphicsAlgorithmContainer)entityShape, 6, 6);
        entityRectangle.setForeground(Graphiti.getGaService().manageColor(diagram, foreground));
        entityRectangle.setBackground(Graphiti.getGaService().manageColor(diagram, background));
        Graphiti.getGaService().setRenderingStyle((AbstractStyle)entityRectangle.getPictogramElement().getGraphicsAlgorithm(), JPAEditorPredefinedColoredAreas.getAdaptedGradientColoredAreas(renderingStyle));
        entityRectangle.setLineWidth(JPAEditorConstants.ENTITY_BORDER_WIDTH);
        entityRectangle.setLineStyle(LineStyle.SOLID);
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)entityRectangle, context.getX(), context.getY(), context.getWidth() == -1 ? 120 : context.getWidth(), context.getHeight() == -1 ? 70 : context.getHeight());
        return entityRectangle;
    }

    private String determineTheAppropriateTypeCommand(JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot) {
        String typeIconId = "";
        if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.Entity)) {
            typeIconId = "org.eclipse.jpt.jpadiagrameditor.ui.entity";
        } else if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.MappedSupeclass)) {
            typeIconId = "org.eclipse.jpt.jpadiagrameditor.ui.mapped_superclass";
        } else if (dot.equals((Object)JPAEditorConstants.DIAGRAM_OBJECT_TYPE.Embeddable)) {
            typeIconId = "org.eclipse.jpt.jpadiagrameditor.ui.embeddable";
        }
        return typeIconId;
    }

    private ContainerShape addHeader(PersistentType addedWrapper, ContainerShape entityShape, int width, JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot) {
        String entityIconId = this.determineTheAppropriateTypeCommand(dot);
        ContainerShape headerIconShape = Graphiti.getPeService().createContainerShape(entityShape, false);
        Rectangle iconRect = Graphiti.getGaService().createRectangle((GraphicsAlgorithmContainer)headerIconShape);
        iconRect.setFilled(Boolean.FALSE);
        iconRect.setLineVisible(Boolean.FALSE);
        iconRect.setHeight(20);
        iconRect.setX(0);
        iconRect.setWidth(24);
        iconRect.setHeight(24);
        iconRect.setY(0);
        Image headerIcon = Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, entityIconId);
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)headerIcon, 7, 7, 16, 16);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)headerIconShape, JPAEditorConstants.PROP_SHAPE_TYPE, JPAEditorConstants.ShapeType.ICON.toString());
        ContainerShape entityHeaderTextShape = Graphiti.getPeService().createContainerShape(entityShape, false);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)entityHeaderTextShape, JPAEditorConstants.PROP_SHAPE_TYPE, JPAEditorConstants.ShapeType.HEADER.toString());
        Rectangle headerRect = Graphiti.getGaService().createRectangle((GraphicsAlgorithmContainer)entityHeaderTextShape);
        headerRect.setFilled(Boolean.FALSE);
        headerRect.setLineVisible(Boolean.FALSE);
        headerRect.setWidth(width - 25);
        headerRect.setHeight(21);
        headerRect.setY(2);
        headerRect.setX(25);
        String headerTextString = JPAEditorUtil.getText(addedWrapper);
        ICompilationUnit cu = JPAEditorUtil.getCompilationUnit(addedWrapper);
        JPAEditorUtil.becomeWorkingCopy(cu);
        headerTextString = JPAEditorUtil.returnSimpleName(headerTextString);
        try {
            if (cu.hasUnsavedChanges()) {
                headerTextString = "* " + headerTextString;
            }
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannot check compilation unit for unsaved changes", e);
        }
        Text headerTextObj = Graphiti.getGaService().createText(this.getDiagram(), (GraphicsAlgorithmContainer)headerRect, headerTextString, "Arial", 8, false, true);
        headerTextObj.setForeground(this.manageColor(JPAEditorConstants.ENTITY_TEXT_FOREGROUND));
        headerTextObj.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        headerTextObj.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)headerTextObj, 1, 2, width, 20);
        return entityHeaderTextShape;
    }

    private void addAttribute(PersistentAttribute pa, ContainerShape compartmentShape) {
        IJPAEditorFeatureProvider fp = this.getFeatureProvider();
        fp.putKeyToBusinessObject(fp.getKeyForBusinessObject(pa), pa);
        PersistentType jpt = (PersistentType)pa.getParent();
        String key = fp.getKeyForBusinessObject(jpt);
        if (fp.getBusinessObjectForKey(key) == null) {
            fp.putKeyToBusinessObject(key, jpt);
        }
        AddContext addContext = new AddContext();
        addContext.setTargetContainer(compartmentShape.getContainer());
        addContext.setNewObject((Object)pa);
        GraphicalAddAttributeFeature graphicalAdd = new GraphicalAddAttributeFeature(fp);
        graphicalAdd.add((IAddContext)addContext);
    }
}

