/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.ejb.internal.operations.TransactionType;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBCreationResourceHandler;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewEnterpriseBeanClassDataModelProvider
extends NewJavaClassDataModelProvider {
    private static final int[] EJB31_VERSIONS = new int[]{31, 30, 30};
    private static final int[] EJB32_VERSIONS = new int[]{32, 31, 31};

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("INewEnterpriseBeanClassDataModelProperties.EJB_NAME");
        propertyNames.add("INewEnterpriseBeanClassDataModelProperties.MAPPED_NAME");
        propertyNames.add("INewEnterpriseBeanClassDataModelProperties.TRANSACTION_TYPE");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("INewEnterpriseBeanClassDataModelProperties.EJB_NAME")) {
            String className = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
            int index = className.lastIndexOf(".");
            className = className.substring(index + 1);
            return className;
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return "";
        }
        if (propertyName.equals("INewEnterpriseBeanClassDataModelProperties.TRANSACTION_TYPE")) {
            return TransactionType.CONTAINER.toString();
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            String value = this.getStringProperty(propertyName);
            if (value == null || value.trim().length() == 0) {
                return WTPCommonPlugin.OK_STATUS;
            }
        } else if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE")) {
            String value = this.getStringProperty(propertyName);
            if (value == null || value.trim().length() == 0) {
                String msg = EJBCreationResourceHandler.Bean_Class_Cannot_Be_In_UI_;
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        } else if ("INewEnterpriseBeanClassDataModelProperties.EJB_NAME".equals(propertyName)) {
            String value = this.getStringProperty(propertyName).trim();
            if (value == null || value.trim().length() == 0) {
                return WTPCommonPlugin.createWarningStatus((String)EJBCreationResourceHandler.WRN_BEAN_NAME_IS_EMPTY);
            }
            return this.validateEjbName();
        }
        return super.validate(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean result = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME") && !this.getDataModel().isPropertySet("INewEnterpriseBeanClassDataModelProperties.EJB_NAME")) {
            this.getDataModel().notifyPropertyChange("INewEnterpriseBeanClassDataModelProperties.EJB_NAME", 2);
        }
        return result;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("INewEnterpriseBeanClassDataModelProperties.TRANSACTION_TYPE")) {
            return DataModelPropertyDescriptor.createDescriptors((Object[])new String[]{TransactionType.CONTAINER.toString(), TransactionType.BEAN.toString()}, (String[])new String[]{EJBCreationResourceHandler.TRANSACTION_TYPE_CONTAINER, EJBCreationResourceHandler.TRANSACTION_TYPE_BEAN});
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    protected IStatus validateEjbName() {
        IModelProvider provider;
        EJBJar modelObject;
        EnterpriseBeans enterpriseBeans;
        IProject project;
        String projectName = this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && projectName.length() > 0 && JavaEEProjectUtilities.isEJBProject((IProject)(project = this.getTargetProject())) && (enterpriseBeans = (modelObject = (EJBJar)(provider = ModelProviderManager.getModelProvider((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName))).getModelObject()).getEnterpriseBeans()) != null) {
            List sessionBeans = enterpriseBeans.getSessionBeans();
            for (Object object : sessionBeans) {
                SessionBean session = (SessionBean)object;
                if (session.getEjbName() == null || this.getDataModel().getStringProperty("INewEnterpriseBeanClassDataModelProperties.EJB_NAME") == null || !session.getEjbName().equals(this.getDataModel().getStringProperty("INewEnterpriseBeanClassDataModelProperties.EJB_NAME").trim())) continue;
                return new Status(4, "org.eclipse.jst.j2ee.ejb", EJBCreationResourceHandler.ERR_BEAN_ALREADY_EXISTS);
            }
        }
        return Status.OK_STATUS;
    }

    protected boolean ejb3xOrLater(int ejbVersion) {
        boolean retVal = false;
        IProject project = this.getTargetProject();
        int[] ejbVersions = EJB31_VERSIONS;
        IProjectFacetVersion facetVersion = null;
        int versionToCheck = ejbVersion;
        switch (ejbVersion) {
            case 31: {
                ejbVersions = EJB31_VERSIONS;
                break;
            }
            case 32: {
                ejbVersions = EJB32_VERSIONS;
            }
        }
        if (project != null) {
            if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
                facetVersion = JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.ejb");
                versionToCheck = ejbVersions[0];
            } else if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
                facetVersion = JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.web");
                versionToCheck = ejbVersions[1];
            } else if (JavaEEProjectUtilities.isWebFragmentProject((IProject)project)) {
                facetVersion = JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.webfragment");
                versionToCheck = ejbVersions[2];
            }
            if (facetVersion != null) {
                int version = J2EEVersionUtil.convertVersionStringToInt((String)facetVersion.getVersionString());
                retVal = version >= versionToCheck;
            }
        }
        return retVal;
    }
}

