/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.ITagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence.SerializableTLDNamespace;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLDNamespace
extends Namespace {
    private static final long serialVersionUID = 9206460825737988441L;
    private TLDNamespaceData _tldData;

    public TLDNamespace(TLDDocument tldDoc, ITagResolvingStrategy<TLDElementDeclaration, String> tagResolver) {
        this._tldData = new DocumentTLDNamespaceData(tldDoc, tagResolver);
    }

    public final String getDisplayName() {
        return this._tldData.getDisplayName();
    }

    public final String getNSUri() {
        return this._tldData.getUri();
    }

    public boolean isInitialized() {
        return this._tldData.isInitialized();
    }

    public final ITagElement getViewElement(String name) {
        return this._tldData.getViewElement(name);
    }

    public final Collection<? extends ITagElement> getViewElements() {
        return Collections.unmodifiableCollection(this._tldData.getAllViewElements().values());
    }

    public final Map<String, ITagElement> getCurrentElements() {
        return Collections.unmodifiableMap(this._tldData.getCurrentElements());
    }

    public final boolean hasViewElements() {
        return this._tldData.getNumTags() > 0;
    }

    private Object writeReplace() {
        return new SerializableTLDNamespace(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocumentTLDNamespaceData
    extends TLDNamespaceData {
        private static final long serialVersionUID = -1098872687238068584L;
        private final transient TLDDocument _tldDoc;
        private final transient ITagResolvingStrategy<TLDElementDeclaration, String> _tagResolver;
        private final transient ILock _tagMapReadWriteLock;
        private Map<String, ITagElement> _tags;

        public DocumentTLDNamespaceData(TLDDocument tldDoc, ITagResolvingStrategy<TLDElementDeclaration, String> tagResolver) {
            this._tldDoc = tldDoc;
            this._tagResolver = tagResolver;
            this._tagMapReadWriteLock = Job.getJobManager().newLock();
        }

        @Override
        public String getDisplayName() {
            String displayName = this._tldDoc.getDisplayName();
            if (displayName == null || "".equals(displayName.trim())) {
                displayName = this.getUri();
            }
            return displayName;
        }

        @Override
        public String getUri() {
            return this._tldDoc.getUri();
        }

        @Override
        public int getNumTags() {
            return this._tldDoc.getElements().getLength();
        }

        private ITagElement createTagElement(String name) {
            CMNode cmNode = this._tldDoc.getElements().getNamedItem(name);
            ITagElement tagElement = null;
            if (cmNode instanceof TLDElementDeclaration && (tagElement = this._tagResolver.resolve((TLDElementDeclaration)cmNode)) == this._tagResolver.getNotFoundIndicator()) {
                tagElement = null;
            }
            return tagElement;
        }

        @Override
        public final Map<String, ITagElement> getAllViewElements() {
            CMNamedNodeMap elementMap = this._tldDoc.getElements();
            Map<String, ITagElement> tags = this.getOrCreateMap(elementMap.getLength());
            if (!this.isInitialized()) {
                int i = 0;
                while (i < elementMap.getLength()) {
                    CMNode cmNode = elementMap.item(i);
                    this.getViewElement(cmNode.getNodeName());
                    ++i;
                }
            }
            return tags;
        }

        @Override
        public ITagElement getViewElement(String name) {
            ITagElement tagElement = null;
            this._tagMapReadWriteLock.acquire();
            Map<String, ITagElement> tags = this.getOrCreateMap(this._tldDoc.getElements().getLength());
            try {
                tagElement = tags.get(name);
                if (tagElement == null && (tagElement = this.createTagElement(name)) != null) {
                    tags.put(tagElement.getName(), tagElement);
                }
            }
            finally {
                this._tagMapReadWriteLock.release();
            }
            return tagElement;
        }

        private synchronized Map<String, ITagElement> getOrCreateMap(int mapSizeHint) {
            if (this._tags == null) {
                int initSize = (int)((float)mapSizeHint / 0.75f) + 1;
                this._tags = Collections.synchronizedMap(new HashMap(initSize));
            }
            return this._tags;
        }

        @Override
        public boolean isInitialized() {
            int tagMapSize;
            int numTags = this.getNumTags();
            return numTags == (tagMapSize = this.getOrCreateMap(3).size());
        }

        @Override
        public Map<String, ITagElement> getCurrentElements() {
            return this.getOrCreateMap(3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TLDNamespaceData
    implements Serializable {
        private static final long serialVersionUID = -1284294636936289804L;

        public abstract String getDisplayName();

        public abstract int getNumTags();

        public abstract String getUri();

        public abstract ITagElement getViewElement(String var1);

        public abstract Map<String, ITagElement> getAllViewElements();

        public abstract boolean isInitialized();

        public abstract Map<String, ITagElement> getCurrentElements();
    }
}

