/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.ResourceUtils;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.CSSTempUtil;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.font.CSSFont;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFont;
import org.eclipse.jst.pagedesigner.css2.style.DefaultStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetListAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.util.CSSClassTraverser;
import org.eclipse.wst.html.core.internal.htmlcss.CSSQueryTraverser;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class CSSUtil {
    private static StyleSheet _userAgentDefault;

    public static String[] getCSSClasses(Document doc) {
        Collection c = Collections.EMPTY_SET;
        if (doc instanceof INodeNotifier) {
            IStyleSheetListAdapter adapter = (IStyleSheetListAdapter)((INodeNotifier)doc).getAdapterFor(IStyleSheetListAdapter.class);
            StyleSheetList ssl = adapter == null ? null : adapter.getStyleSheets();
            CSSClassTraverser traverser = new CSSClassTraverser();
            if (ssl != null) {
                int i = 0;
                int numStyles = ssl.getLength();
                while (i < numStyles) {
                    StyleSheet ss = ssl.item(i);
                    try {
                        traverser.apply((ICSSNode)ss);
                    }
                    catch (ClassCastException ex) {
                        Logger log = PDPlugin.getLogger(CSSStyleDeclaration.class);
                        log.error("Error.CSSUtil.0", (Throwable)ex);
                    }
                    ++i;
                }
                c = traverser.getClassNames();
            }
        }
        String[] result = new String[c.size()];
        c.toArray(result);
        return result;
    }

    public static ICSSStyle getCSSStyle(Element node) {
        ICSSStyle style = null;
        if (node instanceof IDOMElement) {
            style = (ICSSStyle)((IDOMElement)node).getAdapterFor(ICSSStyle.class);
        }
        if (style == null) {
            return DefaultStyle.getInstance();
        }
        return style;
    }

    public static String resolveCSSStyle(ICSSStyle style) {
        ICSSFont object2;
        StringBuffer sb = new StringBuffer();
        Object object1 = style.getColor();
        if (object1 instanceof Color) {
            sb.append("color:");
            sb.append("#").append(Integer.toHexString(((Color)object1).getRed()));
            sb.append("#").append(Integer.toHexString(((Color)object1).getGreen()));
            sb.append("#").append(Integer.toHexString(((Color)object1).getBlue()));
            sb.append(";");
        }
        if ((object2 = style.getCSSFont()) instanceof CSSFont) {
            sb.append(((CSSFont)object2).getCSSString());
        }
        return sb.toString();
    }

    public static CSSStyleDeclaration getCSSDeclaration(Element element, String pseudoName) {
        List styleSheets = CSSTempUtil.getStyleSheets(element);
        CSSQueryTraverser query = new CSSQueryTraverser();
        query.setTraverseImported(true);
        query.setTraverseImportFirst(true);
        query.setElement(element, pseudoName);
        if (styleSheets != null) {
            int i = 0;
            int numStyles = styleSheets.size();
            while (i < numStyles) {
                StyleSheet ss = (StyleSheet)styleSheets.get(i);
                try {
                    query.apply((ICSSNode)ss);
                }
                catch (ClassCastException ex) {
                    Logger log = PDPlugin.getLogger(CSSStyleDeclaration.class);
                    log.error("Error.CSSUtil.0", (Throwable)ex);
                }
                ++i;
            }
        }
        ICSSStyleDeclaration declare = query.getDeclaration();
        return declare;
    }

    public static CSSStyleDeclaration getDefaultCSSDeclaration(Element element, String pseudoName) {
        Logger log;
        CSSQueryTraverser query = new CSSQueryTraverser();
        query.setTraverseImported(true);
        query.setTraverseImportFirst(true);
        query.setElement(element, pseudoName);
        try {
            CSSUtil.getUserAgentDefaultStyleSheet(element);
        }
        catch (UnsupportedEncodingException e) {
            log = PDPlugin.getLogger(CSSStyleDeclaration.class);
            log.error("Error.CSSUtil.1", (Throwable)e);
        }
        catch (IOException e) {
            log = PDPlugin.getLogger(CSSStyleDeclaration.class);
            log.error("Error.CSSUtil.2", (Throwable)e);
        }
        if (_userAgentDefault != null) {
            try {
                query.apply((ICSSNode)_userAgentDefault);
            }
            catch (ClassCastException ex) {
                log = PDPlugin.getLogger(CSSStyleDeclaration.class);
                log.error("Error.CSSUtil.3", (Throwable)ex);
            }
        }
        ICSSStyleDeclaration declare = query.getDeclaration();
        return declare;
    }

    private static StyleSheet getUserAgentDefaultStyleSheet(Element element) throws UnsupportedEncodingException, IOException {
        if (_userAgentDefault == null) {
            InputStream input = null;
            try {
                input = CSSUtil.class.getResourceAsStream("html4.css");
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit("html4.css", input, null);
                ICSSModel cssmodel = (ICSSModel)model;
                _userAgentDefault = (StyleSheet)cssmodel.getDocument();
            }
            finally {
                ResourceUtils.ensureClosed((InputStream)input);
            }
        }
        return _userAgentDefault;
    }
}

