/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.preferences.database;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;

public class DatabaseConnection {
    public static final String PROP_NAME_NAME = "name";
    public static final String PROP_NAME_CONN_INFO = "connectionInfo";
    private PropertyChangeSupport m_propChangeSupport = new PropertyChangeSupport(this);
    private String m_name;
    private DatabaseConnectionInfo m_connectionInfo;

    public DatabaseConnection(String name, DatabaseConnectionInfo connectionInfo) {
        this.setName(name);
        this.setConnectionInfo(connectionInfo);
    }

    public DatabaseConnection(DatabaseConnection toCopy) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        this.setName(toCopy.getName());
        DatabaseConnectionInfo infoToCopy = toCopy.getConnectionInfo();
        this.setConnectionInfo((DatabaseConnectionInfo)BeanUtils.cloneBean((Object)infoToCopy));
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        Validate.notEmpty((String)name);
        String oldValue = this.m_name;
        this.m_name = name;
        this.m_propChangeSupport.firePropertyChange(PROP_NAME_NAME, oldValue, this.m_name);
    }

    public void setConnectionInfo(DatabaseConnectionInfo connectionInfo) {
        Validate.notNull((Object)connectionInfo);
        DatabaseConnectionInfo oldValue = this.m_connectionInfo;
        this.m_connectionInfo = connectionInfo;
        this.m_propChangeSupport.firePropertyChange(PROP_NAME_CONN_INFO, oldValue, this.m_connectionInfo);
    }

    public DatabaseConnectionInfo getConnectionInfo() {
        return this.m_connectionInfo;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_propChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_propChangeSupport.removePropertyChangeListener(l);
    }
}

