/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectCombo<TheObject>
extends Combo {
    private List<TheObject> m_values;
    private boolean m_nullSelectionAllowed;
    private Comparator<String> m_comparator;

    public DirectCombo(Composite parent, int style, List<TheObject> values, List<String> displayValues, boolean isNullSelectionAllowed, Comparator<String> comparator) {
        super(parent, style | 8);
        this.m_nullSelectionAllowed = isNullSelectionAllowed;
        this.m_comparator = comparator;
        this.init(values, displayValues, isNullSelectionAllowed, comparator);
    }

    public DirectCombo(Composite parent, int style, List<TheObject> values, List<String> displayValues, boolean isNullSelectionAllowed, boolean sortEntries) {
        this(parent, style, values, displayValues, isNullSelectionAllowed, sortEntries ? new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        } : null);
    }

    private void init(List<TheObject> values, List<String> displayValues, boolean isNullSelectionAllowed, Comparator<String> comparator) {
        Validate.isTrue((values.size() == displayValues.size() ? 1 : 0) != 0, (String)"values and displayValues don't have the same number of items.");
        List<String> display = displayValues;
        if (comparator == null) {
            this.m_values = new ArrayList<TheObject>(values);
            if (isNullSelectionAllowed) {
                this.m_values.add(0, null);
                display.add(0, "");
            }
        } else {
            display = this.sortKeys(values, display, comparator, isNullSelectionAllowed);
        }
        this.removeAll();
        for (String displayValue : display) {
            super.add(displayValue);
        }
        TheObject defaultSelectedObject = isNullSelectionAllowed ? null : (values.size() > 0 ? (TheObject)values.get(0) : null);
        this.setSelectedObject(defaultSelectedObject);
    }

    private List<String> sortKeys(List<TheObject> values, List<String> displayValues, Comparator<String> comparator, boolean isNullSelectionAllowed) {
        TreeMap<String, TheObject> sorter = new TreeMap<String, TheObject>(comparator);
        int size = values.size();
        int i = 0;
        while (i < size) {
            sorter.put(displayValues.get(i), values.get(i));
            ++i;
        }
        if (isNullSelectionAllowed) {
            ++size;
        }
        this.m_values = new ArrayList<TheObject>(size);
        ArrayList<String> result = new ArrayList<String>(size);
        if (isNullSelectionAllowed) {
            this.m_values.add(null);
            result.add("");
        }
        for (Map.Entry entry : sorter.entrySet()) {
            this.m_values.add(entry.getValue());
            result.add((String)entry.getKey());
        }
        return result;
    }

    public void setSelectedObject(TheObject o) {
        int index = this.m_values.indexOf(o);
        this.select(index);
    }

    public TheObject getSelectedObject() {
        int index = this.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.m_values.get(index);
    }

    public void setItems(List<TheObject> values, List<String> displayValues) {
        this.init(values, displayValues, this.m_nullSelectionAllowed, this.m_comparator);
    }

    protected Comparator<String> getComparator() {
        return this.m_comparator;
    }

    protected boolean isNullSelectionAllowed() {
        return this.m_nullSelectionAllowed;
    }

    public List<TheObject> getValues() {
        return this.m_values;
    }

    protected void checkSubclass() {
    }

    @Deprecated
    public void add(String string, int index) {
        super.add(string, index);
    }

    @Deprecated
    public void add(String string) {
        super.add(string);
    }

    @Deprecated
    public void remove(int start, int end) {
        super.remove(start, end);
    }

    @Deprecated
    public void remove(int index) {
        super.remove(index);
    }

    @Deprecated
    public void remove(String string) {
        super.remove(string);
    }

    @Deprecated
    public void setItem(int index, String string) {
        super.setItem(index, string);
    }

    @Deprecated
    public void setItems(String[] items) {
        super.setItems(items);
    }

    @Deprecated
    public void setText(String string) {
        super.setText(string);
    }
}

