/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathHacker {
    private static final Class[] PARAMETERS = new Class[]{URL.class};

    private ClassPathHacker() {
    }

    public static void addFile(File f) throws IOException {
        ClassPathHacker.addURL(f.toURI().toURL());
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", PARAMETERS);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Error, could not add URL to system classloader");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Error, could not add URL to system classloader");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static void addURL(URL u, ClassLoader classLoader) throws IOException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", PARAMETERS);
        method.setAccessible(true);
        method.invoke((Object)classLoader, u);
    }

    public static List<Class> findClasses(URL directoryUrl, String packageName) throws ClassNotFoundException, MalformedURLException {
        ArrayList<Class> classes = new ArrayList<Class>();
        File directory = new File(directoryUrl.getFile());
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String fileName = file.getName();
            if (file.isDirectory()) {
                classes.addAll(ClassPathHacker.findClasses(file.toURI().toURL(), String.valueOf(packageName) + '.' + fileName));
            } else if (fileName.endsWith(".class")) {
                classes.add(Class.forName(String.valueOf(packageName) + '.' + fileName.substring(0, fileName.length() - 6)));
            }
            ++i;
        }
        return classes;
    }

    public static List<Class> findClassesInJar(URL resource, String pkgname, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        String relPath = pkgname.replace('.', '/');
        String path = resource.getPath().replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
        path = path.replaceFirst("bundleFile[!].*", "bundleFile");
        path = URLDecoder.decode(path, "utf-8");
        ArrayList<Class> classes = new ArrayList<Class>();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(path);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                String className = null;
                if (!entryName.endsWith(".class") || !entryName.startsWith(relPath) || (className = entryName.replace('/', '.').replace('\\', '.').replaceAll(".class", "")) == null) continue;
                classes.add(Class.forName(className, true, classLoader));
            }
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        return classes;
    }
}

