/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.processes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.data.Data;
import org.eclipse.jwt.meta.model.data.impl.DataImpl;
import org.eclipse.jwt.meta.model.processes.Guard;
import org.eclipse.jwt.meta.model.processes.GuardSpecification;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.figures.core.NamedElementFigure;
import org.eclipse.jwt.we.figures.processes.GuardFigure;
import org.eclipse.jwt.we.misc.guards.NotaFormulaException;
import org.eclipse.jwt.we.misc.guards.StringtoTreeParser;
import org.eclipse.jwt.we.misc.guards.TreetoStringParser;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.util.internal.StringParser;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.parts.core.GraphicalModelElementEditPart;
import org.eclipse.jwt.we.parts.processes.directEdit.GuardCellEditorLocator;
import org.eclipse.jwt.we.parts.processes.directEdit.GuardDirectEditManager;
import org.eclipse.jwt.we.parts.processes.policies.GuardDirectEditPolicy;
import org.eclipse.jwt.we.parts.processes.policies.GuardSelectionEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuardEditPart
extends GraphicalModelElementEditPart {
    private Logger logger = Logger.getLogger(GuardEditPart.class);
    private DirectEditManager directEditManager;

    @Override
    public Class getModelClass() {
        return Guard.class;
    }

    public Guard getGuard() {
        return (Guard)this.getModel();
    }

    protected List getModelChildren() {
        ArrayList<GuardSpecification> result = new ArrayList<GuardSpecification>();
        if (this.getGuard().getDetailedSpecification() != null) {
            result.add(this.getGuard().getDetailedSpecification());
        }
        return result;
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new GuardSelectionEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new GuardDirectEditPolicy());
    }

    @Override
    public void performRequest(Request request) {
        super.performRequest(request);
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        }
    }

    protected void performDirectEdit() {
        if (this.directEditManager == null) {
            this.directEditManager = new GuardDirectEditManager((GraphicalEditPart)this, new GuardCellEditorLocator((GuardFigure)this.getFigure()));
        }
        this.directEditManager.show();
    }

    private void refreshShortDesc() {
        try {
            GuardSpecification gs = this.getGuard().getDetailedSpecification();
            if (gs == null) {
                return;
            }
            String newformula = TreetoStringParser.getString(gs);
            this.getGuard().setShortdescription(newformula);
        }
        catch (Exception ex) {
            this.logger.debug(ex);
        }
    }

    public EAttribute getActiveFeature() {
        if (Views.getInstance().displayObject((EObject)ProcessesPackage.Literals.GUARD__SHORTDESCRIPTION)) {
            return ProcessesPackage.eINSTANCE.getGuard_Shortdescription();
        }
        return ProcessesPackage.eINSTANCE.getGuard_Textualdescription();
    }

    public String getActiveText(boolean trim) {
        int maxLineLengthWrap;
        int maxLineLengthCut;
        Guard guard = this.getGuard();
        if (guard == null) {
            return "";
        }
        String result = "";
        boolean autoWrap = PreferenceReader.guardAutoWrap.get();
        if (Views.getInstance().displayObject((EObject)ProcessesPackage.Literals.GUARD__SHORTDESCRIPTION)) {
            if (guard.getShortdescription() != null) {
                result = guard.getShortdescription();
            }
            maxLineLengthCut = PreferenceReader.guardShortCut.get();
            maxLineLengthWrap = PreferenceReader.guardShortWrap.get();
        } else {
            if (guard.getTextualdescription() != null) {
                result = guard.getTextualdescription();
            }
            maxLineLengthCut = PreferenceReader.guardTextualCut.get();
            maxLineLengthWrap = PreferenceReader.guardTextualWrap.get();
        }
        if (trim && maxLineLengthCut != 0 && result.length() > maxLineLengthCut) {
            result = result.substring(0, maxLineLengthCut - 1);
            result = String.valueOf(result) + "...";
        }
        if (trim && maxLineLengthWrap != 0 && result.length() > maxLineLengthWrap) {
            ArrayList splittedString;
            String temp = result;
            if (autoWrap) {
                String[] controlCharacters = new String[]{" ", "==", ">", "<", "!=", "&&", "||", "(", ")", ".", ","};
                splittedString = StringParser.splitChar(temp, controlCharacters, 3);
            } else {
                splittedString = StringParser.splitLength(temp, maxLineLengthWrap);
            }
            result = StringParser.concatWithLineWraps(splittedString, maxLineLengthWrap);
        }
        return result;
    }

    private Color getActiveColor() {
        Color color = Views.getInstance().displayObject((EObject)ProcessesPackage.Literals.GUARD__SHORTDESCRIPTION) ? PreferenceReader.appearanceguardShortColor.get() : PreferenceReader.appearanceguardTextualColor.get();
        return color;
    }

    protected void refreshVisuals() {
        try {
            super.refreshVisuals();
            ((NamedElementFigure)this.getFigure()).setName(this.getActiveText(true));
            ((NamedElementFigure)this.getFigure()).getLabel().setForegroundColor(this.getActiveColor());
        }
        catch (Exception ex) {
            this.logger.debug(ex);
        }
    }

    private EObject getRootNode(EObject eobj) {
        if (eobj == null || eobj.eContainer() == null) {
            return eobj;
        }
        return this.getRootNode(eobj.eContainer());
    }

    private void collectData(EObject obj, List<Data> datalist) {
        if (obj instanceof Package) {
            Package p = (Package)obj;
            EList elements = p.getElements();
            int i = 0;
            while (i < elements.size()) {
                Object elem = elements.get(i);
                if (elem instanceof DataImpl) {
                    datalist.add((Data)elem);
                }
                ++i;
            }
            EList subpackages = p.getSubpackages();
            int i2 = 0;
            while (i2 < subpackages.size()) {
                this.collectData((EObject)subpackages.get(i2), datalist);
                ++i2;
            }
        }
    }

    private void setSpecificationTree(String oldValue, String newValue) {
        block12: {
            Guard guard = this.getGuard();
            if (guard != null && guard.getShortdescription() != null && !guard.getShortdescription().equals("")) {
                GuardSpecification rootnode;
                block11: {
                    rootnode = null;
                    try {
                        ArrayList<Data> datalist = new ArrayList<Data>();
                        this.collectData(this.getRootNode((EObject)guard), datalist);
                        StringtoTreeParser stp = new StringtoTreeParser(guard.getShortdescription(), datalist);
                        rootnode = stp.getRootNode();
                    }
                    catch (Exception ex) {
                        if (oldValue == null) {
                            oldValue = "";
                        }
                        if (newValue == null) {
                            newValue = "";
                        }
                        if (oldValue.equals(newValue)) break block11;
                        String message = "";
                        if (ex instanceof NotaFormulaException) {
                            message = " (" + ((NotaFormulaException)ex).getMessage() + ")";
                        }
                        message = String.valueOf(PluginProperties.guards_ParseError_message) + message + ".\n" + PluginProperties.guards_ParseError_message2;
                        MessageDialog.openError((Shell)GeneralHelper.getActiveShell(), (String)PluginProperties.guards_ParseError_title, (String)message);
                        this.getGuard().setShortdescription(oldValue);
                    }
                }
                try {
                    GuardSpecification gs = guard.getDetailedSpecification();
                    if (gs != null) {
                        EcoreUtil.replace((EObject)gs, rootnode);
                        break block12;
                    }
                    guard.setDetailedSpecification(rootnode);
                }
                catch (Exception ex) {
                    this.logger.debug(ex);
                }
            } else if (guard != null) {
                guard.setDetailedSpecification(null);
            }
        }
    }

    @Override
    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        try {
            Object obj = notification.getNotifier();
            if (obj instanceof Guard) {
                int featureId = notification.getFeatureID(Guard.class);
                int notificationid = notification.getEventType();
                switch (notificationid) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        switch (featureId) {
                            case 4: {
                                this.setSpecificationTree(notification.getOldStringValue(), notification.getNewStringValue());
                                this.refreshChildren();
                            }
                            case 3: 
                            case 5: {
                                this.refreshVisuals();
                            }
                        }
                    }
                }
            } else if (obj instanceof GuardSpecification) {
                int notificationid = notification.getEventType();
                switch (notificationid) {
                    case 1: {
                        this.refreshShortDesc();
                        this.refreshVisuals();
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.debug(ex);
        }
    }
}

