/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.dialogs.AbstractMavenDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectSelectionDialog
extends AbstractMavenDialog {
    private static final Logger log = LoggerFactory.getLogger(MavenProjectSelectionDialog.class);
    protected static final String DIALOG_SETTINGS = MavenProjectSelectionDialog.class.getName();
    protected static final long SEARCH_DELAY = 500L;
    private FilteredTree filteredTree;
    private boolean useCheckboxTree;

    public MavenProjectSelectionDialog(Shell parent, boolean useCheckboxTree) {
        this(parent);
        this.useCheckboxTree = useCheckboxTree;
    }

    public MavenProjectSelectionDialog(Shell parent) {
        super(parent, DIALOG_SETTINGS);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(Messages.projectSelectionDialogTitle);
    }

    protected void computeResult() {
        if (this.useCheckboxTree) {
            ArrayList<Object> result = new ArrayList<Object>();
            this.collectCheckedItems(this.getViewer().getTree().getItems(), result);
            this.setResult(result);
        } else {
            this.setResult(((IStructuredSelection)this.getViewer().getSelection()).toList());
        }
    }

    private void collectCheckedItems(TreeItem[] items, List<Object> list) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object data;
            TreeItem item = treeItemArray[n2];
            if (item.getChecked() && (data = item.getData()) != null) {
                list.add(data);
            }
            this.collectCheckedItems(item.getItems(), list);
            ++n2;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.readSettings();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.filteredTree = new FilteredTree(composite, 0x800 | (this.useCheckboxTree ? 32 : 0), new PatternFilter(), true);
        this.filteredTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.getViewer().setContentProvider((IContentProvider)new MavenContainerContentProvider());
        this.getViewer().setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.getViewer().setInput((Object)ResourcesPlugin.getWorkspace());
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MavenProjectSelectionDialog.this.okPressed();
            }
        });
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected TreeViewer getViewer() {
        return this.filteredTree.getViewer();
    }

    protected static class MavenContainerContentProvider
    implements ITreeContentProvider {
        protected MavenContainerContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            IContainer container;
            if (parent instanceof IWorkspace) {
                IProject[] projects = ((IWorkspace)parent).getRoot().getProjects();
                ArrayList<IProject> children = new ArrayList<IProject>();
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    try {
                        if (project.isOpen() && project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                            children.add(project);
                        }
                    }
                    catch (CoreException e) {
                        log.error("Error checking project: " + e.getMessage(), (Throwable)e);
                    }
                    ++n2;
                }
                return children.toArray();
            }
            if (parent instanceof IContainer && (container = (IContainer)parent).isAccessible()) {
                try {
                    ArrayList<IResource> children = new ArrayList<IResource>();
                    IResource[] members = container.members();
                    int i = 0;
                    while (i < members.length) {
                        if (members[i] instanceof IContainer && ((IContainer)members[i]).exists((IPath)new Path("pom.xml"))) {
                            children.add(members[i]);
                        }
                        ++i;
                    }
                    return children.toArray();
                }
                catch (CoreException e) {
                    log.error("Error checking container: " + e.getMessage(), (Throwable)e);
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object arg1, Object arg2) {
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }
    }
}

