/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core.model;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILineRange;
import org.eclipse.mylyn.reviews.internal.core.model.Location;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsPackage;

public class LineLocation
extends Location
implements ILineLocation {
    protected EList<ILineRange> ranges;
    protected static final int RANGE_MIN_EDEFAULT = 0;
    protected static final int RANGE_MAX_EDEFAULT = 0;

    protected LineLocation() {
    }

    @Override
    protected EClass eStaticClass() {
        return ReviewsPackage.Literals.LINE_LOCATION;
    }

    @Override
    public List<ILineRange> getRanges() {
        if (this.ranges == null) {
            this.ranges = new EObjectContainmentEList.Resolving(ILineRange.class, (InternalEObject)this, 1);
        }
        return this.ranges;
    }

    @Override
    public int getRangeMin() {
        int min = -1;
        for (ILineRange range : this.getRanges()) {
            if (min != -1 && range.getStart() >= min) continue;
            min = range.getStart();
        }
        return min == -1 ? 0 : min;
    }

    @Override
    public int getRangeMax() {
        int max = -1;
        for (ILineRange range : this.getRanges()) {
            if (max != -1 && range.getStart() <= max) continue;
            max = range.getStart();
        }
        return max == -1 ? 0 : max;
    }

    @Override
    public long getIndex() {
        return this.getRangeMin();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getRanges()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getRanges();
            }
            case 2: {
                return this.getRangeMin();
            }
            case 3: {
                return this.getRangeMax();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getRanges().clear();
                this.getRanges().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getRanges().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.ranges != null && !this.ranges.isEmpty();
            }
            case 2: {
                return this.getRangeMin() != 0;
            }
            case 3: {
                return this.getRangeMax() != 0;
            }
        }
        return super.eIsSet(featureID);
    }
}

