/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl.delta;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.delta.IDBDelta;
import org.eclipse.net4j.db.ddl.delta.IDBDeltaVisitor;
import org.eclipse.net4j.internal.db.ddl.DBNamedElement;
import org.eclipse.net4j.internal.db.ddl.DBSchemaElement;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.PositionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBDelta
extends DBNamedElement
implements IDBDelta {
    private static final IDBDelta[] NO_ELEMENTS = new IDBDelta[0];
    private static final long serialVersionUID = 1L;
    private DBDelta parent;
    private IDBDelta.ChangeKind changeKind;
    private transient IDBDelta[] elements;

    public DBDelta(DBDelta parent, String name, IDBDelta.ChangeKind changeKind) {
        super(name);
        this.parent = parent;
        this.changeKind = changeKind;
    }

    protected DBDelta() {
    }

    @Override
    public DBDelta getParent() {
        return this.parent;
    }

    @Override
    public final IDBDelta.ChangeKind getChangeKind() {
        return this.changeKind;
    }

    @Override
    public final int compareTo(IDBDelta delta2) {
        int result = this.getDeltaType().compareTo(delta2.getDeltaType());
        if (result == 0) {
            if (this instanceof PositionProvider && delta2 instanceof PositionProvider) {
                PositionProvider withPosition1 = (PositionProvider)this;
                PositionProvider withPosition2 = (PositionProvider)delta2;
                return withPosition1.getPosition() - withPosition2.getPosition();
            }
            result = this.getName().compareTo(delta2.getName());
        }
        return result;
    }

    @Override
    public final void accept(IDBDeltaVisitor visitor) {
        try {
            this.doAccept(visitor);
        }
        catch (IDBDeltaVisitor.StopRecursion ex) {
            return;
        }
        IDBDelta[] iDBDeltaArray = this.getElements();
        int n = iDBDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDBDelta delta = iDBDeltaArray[n2];
            delta.accept(visitor);
            ++n2;
        }
    }

    protected abstract void doAccept(IDBDeltaVisitor var1);

    public final boolean isEmpty() {
        return this.getElements().length == 0;
    }

    public final IDBDelta[] getElements() {
        if (this.elements == null) {
            ArrayList<IDBDelta> result = new ArrayList<IDBDelta>();
            this.collectElements(result);
            if (result.isEmpty()) {
                this.elements = NO_ELEMENTS;
            } else {
                this.elements = result.toArray(new IDBDelta[result.size()]);
                Arrays.sort(this.elements);
            }
        }
        return this.elements;
    }

    protected final void resetElements() {
        this.elements = null;
    }

    protected abstract void collectElements(List<IDBDelta> var1);

    @Override
    public void dump(Writer writer) throws IOException {
        int level = this.getLevel();
        int i = 0;
        while (i < level) {
            writer.append("  ");
            ++i;
        }
        writer.append(this.getChangeKind().toString());
        writer.append(" ");
        writer.append(this.getDeltaType().toString());
        writer.append(" ");
        writer.append(this.getName());
        this.dumpAdditionalProperties(writer);
        writer.append(StringUtil.NL);
        IDBDelta[] iDBDeltaArray = this.getElements();
        int n = iDBDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDBDelta delta = iDBDeltaArray[n2];
            ((DBDelta)delta).dump(writer);
            ++n2;
        }
    }

    protected void dumpAdditionalProperties(Writer writer) throws IOException {
    }

    private int getLevel() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getLevel() + 1;
    }

    public static String getName(IDBSchemaElement element, IDBSchemaElement oldElement) {
        return oldElement == null ? element.getName() : oldElement.getName();
    }

    public static IDBDelta.ChangeKind getChangeKind(Object object, Object oldObject) {
        return object == null ? IDBDelta.ChangeKind.REMOVE : (oldObject == null ? IDBDelta.ChangeKind.ADD : IDBDelta.ChangeKind.CHANGE);
    }

    protected static <T extends IDBSchemaElement> void compare(T[] elements, T[] oldElements, SchemaElementComparator<T> comparator) {
        String name;
        int i = 0;
        while (i < elements.length) {
            T element = elements[i];
            name = element.getName();
            IDBSchemaElement oldElement = DBSchemaElement.findElement(oldElements, (String)name);
            comparator.compare(element, oldElement);
            ++i;
        }
        i = 0;
        while (i < oldElements.length) {
            T oldElement = oldElements[i];
            name = oldElement.getName();
            if (DBSchemaElement.findElement(elements, (String)name) == null) {
                comparator.compare(null, oldElement);
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SchemaElementComparator<T extends IDBSchemaElement> {
        public void compare(T var1, T var2);
    }
}

