/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.ui.actions.SafeAction;
import org.eclipse.net4j.util.ui.widgets.SashComposite;

public abstract class SashLayoutAction
extends SafeAction
implements IListener {
    private SashComposite sashComposite;

    public SashLayoutAction(SashComposite sashComposite, String text) {
        super(text, 8);
        this.sashComposite = sashComposite;
        this.notifyEvent(null);
        sashComposite.addListener(this);
    }

    public SashComposite getSashComposite() {
        return this.sashComposite;
    }

    public void dispose() {
        this.sashComposite.removeListener(this);
    }

    public static class Horizontal
    extends SashLayoutAction {
        public Horizontal(SashComposite sashComposite) {
            super(sashComposite, Messages.getString("SashLayoutAction_1"));
        }

        protected void safeRun() throws Exception {
            this.getSashComposite().setVertical(false);
        }

        public void notifyEvent(IEvent event) {
            this.setChecked(!this.getSashComposite().isVertical());
        }
    }

    public static class LayoutMenu
    extends MenuManager {
        private SafeAction verticalAction;
        private SafeAction horizontalAction;

        public LayoutMenu(SashComposite sashComposite) {
            super(Messages.getString("SashLayoutAction_2"));
            this.verticalAction = new Vertical(sashComposite);
            this.add((IAction)this.verticalAction);
            this.horizontalAction = new Horizontal(sashComposite);
            this.add((IAction)this.horizontalAction);
        }

        public SafeAction getVerticalAction() {
            return this.verticalAction;
        }

        public SafeAction getHorizontalAction() {
            return this.horizontalAction;
        }
    }

    public static class Vertical
    extends SashLayoutAction {
        public Vertical(SashComposite sashComposite) {
            super(sashComposite, Messages.getString("SashLayoutAction_0"));
        }

        protected void safeRun() throws Exception {
            this.getSashComposite().setVertical(true);
        }

        public void notifyEvent(IEvent event) {
            this.setChecked(this.getSashComposite().isVertical());
        }
    }
}

