/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.documentation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static final String USE_RICH_TEXT = "useRichtext";
    public static final String PLUGIN_ID = "org.eclipse.papyrus.views.documentation";
    public static final String TOGGLE_LINKING = "ToggleLinking";
    private static Activator plugin;
    IPropertyChangeListener listener = event -> {
        IViewPart view;
        if ("useDocumentationProfile" == event.getProperty() && (view = EditorHelper.getActiveWindow().getActivePage().findView("org.eclipse.papyrus.views.documentation.DocumentationView")) != null) {
            EditorHelper.getActiveWindow().getActivePage().hideView(view);
            try {
                EditorHelper.getActiveWindow().getActivePage().showView("org.eclipse.papyrus.views.documentation.DocumentationView");
            }
            catch (PartInitException e) {
                Activator.logError(e.getMessage());
            }
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.listener);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.listener != null) {
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.listener);
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void logWarning(String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(2, PLUGIN_ID, message));
    }

    public static void logError(String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static void logInfo(String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void logException(Exception exception) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, exception.getLocalizedMessage(), (Throwable)exception));
    }

    public boolean getToogleLinkingSetting() {
        String linked = this.getDialogSettings().get("org.eclipse.papyrus.views.documentation_ToggleLinking");
        return linked != null ? Boolean.parseBoolean(linked) : true;
    }

    public void setToggleEditorSetting(boolean toggleLinkingSetting) {
        if (toggleLinkingSetting != this.getToogleLinkingSetting()) {
            this.getDialogSettings().put("org.eclipse.papyrus.views.documentation_ToggleLinking", toggleLinkingSetting);
        }
    }

    public boolean getUseRichTextSetting() {
        return org.eclipse.papyrus.infra.ui.Activator.getDefault().getPreferenceStore().getBoolean("useCkEditor");
    }

    public static boolean getToolbarInitialExpendedPreference() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("toolbarInitialExpanded");
    }

    public static boolean getUseDocumentationProfilePreference() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("useDocumentationProfile");
    }
}

