/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class HeadNodeGroup {
    private final @NonNull List<@NonNull Node> headGroupNodes;
    private Deque<@NonNull Node> workList = null;
    private Set<@NonNull Node> uniqueNodes = null;
    private Set<@NonNull Node> iteratedNodes = null;
    private Set<@NonNull Node> aggregateNodes = null;

    public HeadNodeGroup(@NonNull List<@NonNull Node> headGroupNodes) {
        this.headGroupNodes = headGroupNodes;
    }

    private boolean accumulateReachableTargets(@NonNull Node sourceNode) {
        boolean gotOne = false;
        boolean isIteratedSource = this.iteratedNodes.contains(sourceNode);
        boolean isAggregateSource = this.aggregateNodes.contains(sourceNode);
        boolean isOldSource = sourceNode.isOld();
        for (Edge source2targetEdge : QVTscheduleUtil.getOutgoingEdges((Node)sourceNode)) {
            if (!(isOldSource ? source2targetEdge.isOld() : source2targetEdge.isNew())) continue;
            boolean isAggregateArgument = false;
            Type targetType = null;
            Node targetNode = QVTscheduleUtil.getTargetNode((Edge)source2targetEdge);
            if (!(this.uniqueNodes.contains(targetNode) || this.iteratedNodes.contains(targetNode) || this.aggregateNodes.contains(targetNode))) {
                if (source2targetEdge.isCast() || source2targetEdge.isNavigation()) {
                    Property targetProperty = QVTscheduleUtil.getProperty((NavigableEdge)((NavigableEdge)source2targetEdge));
                    targetType = targetProperty.getType();
                } else if (!source2targetEdge.isPredicate() && source2targetEdge.isComputation()) {
                    isAggregateArgument = isAggregateSource && targetNode.isOperation();
                    boolean allArgumentsReachable = true;
                    for (Edge argumentEdge : QVTscheduleUtil.getIncomingEdges((Node)targetNode)) {
                        if (argumentEdge == source2targetEdge || !argumentEdge.isComputation()) continue;
                        Node argumentNode = QVTscheduleUtil.getSourceNode((Edge)argumentEdge);
                        if (!(argumentNode.isConstant() || this.uniqueNodes.contains(argumentNode) || this.iteratedNodes.contains(argumentNode) || this.aggregateNodes.contains(argumentNode))) {
                            allArgumentsReachable = false;
                            break;
                        }
                        Class argumentType = argumentNode.getCompleteClass().getPrimaryClass();
                        if (!(argumentType instanceof CollectionType)) continue;
                        isAggregateArgument = targetNode.isOperation();
                    }
                    if (allArgumentsReachable) {
                        targetType = targetNode.getCompleteClass().getPrimaryClass();
                    }
                }
            }
            if (targetType == null) continue;
            if (targetType instanceof CollectionType) {
                this.aggregateNodes.add(targetNode);
            } else if ((isAggregateSource || isIteratedSource) && !isAggregateArgument) {
                this.iteratedNodes.add(targetNode);
            } else {
                this.uniqueNodes.add(targetNode);
            }
            this.workList.add(targetNode);
            gotOne = true;
        }
        return gotOne;
    }

    private void accumulateReachables() {
        this.workList = new ArrayDeque<Node>(this.headGroupNodes);
        this.uniqueNodes = new HashSet<Node>(this.headGroupNodes);
        this.iteratedNodes = new HashSet<Node>();
        this.aggregateNodes = new HashSet<Node>();
        while (!this.workList.isEmpty()) {
            Node workNode = this.workList.removeFirst();
            this.accumulateReachableTargets(workNode);
        }
    }

    public @NonNull Iterable<@NonNull Node> getHeadNodes() {
        return this.headGroupNodes;
    }

    public @NonNull Node getPreferredHeadNode() {
        return this.headGroupNodes.get(0);
    }

    private @NonNull Set<@NonNull Node> getToOneSet() {
        Set<@NonNull Node> toOneSet2 = this.uniqueNodes;
        if (toOneSet2 == null) {
            this.accumulateReachables();
            toOneSet2 = this.uniqueNodes;
            assert (toOneSet2 != null);
        }
        return toOneSet2;
    }

    public boolean isDeriveableFrom(@NonNull HeadNodeGroup thatHeadNodeGroup) {
        return thatHeadNodeGroup.getToOneSet().containsAll(this.headGroupNodes);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.headGroupNodes.iterator().next().getOwningRegion());
        s.append("\n\theads:");
        for (Node node : this.headGroupNodes) {
            s.append("\n\t\t");
            s.append(node);
        }
        if (this.uniqueNodes != null) {
            s.append("\n\tto-ones:");
            for (Node node : this.uniqueNodes) {
                s.append("\n\t\t");
                s.append(node);
            }
        }
        if (this.iteratedNodes != null) {
            s.append("\n\tto-iterated:");
            for (Node node : this.iteratedNodes) {
                s.append("\n\t\t");
                s.append(node);
            }
        }
        if (this.aggregateNodes != null) {
            s.append("\n\tto-aggregates:");
            for (Node node : this.aggregateNodes) {
                s.append("\n\t\t");
                s.append(node);
            }
        }
        if (this.workList != null) {
            s.append("\n\twork-list:");
            for (Node node : this.workList) {
                s.append("\n\t\t");
                s.append(node);
            }
        }
        return s.toString();
    }
}

