/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.AbstractPartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicPartitionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.InternallyAcyclicPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;

public class CyclicPartition
extends AbstractPartialRegionAnalysis<Partition>
implements InternallyAcyclicPartition,
Partition {
    protected final @NonNull String name;
    protected final @NonNull CyclicPartitionsAnalysis cyclesAnalysis;
    private int parallelScheduleDepth = -1;
    protected final @NonNull Set<@NonNull Partition> partitions;
    protected final @NonNull Map<@NonNull Partition, @NonNull Set<@NonNull Partition>> partition2predecessors = new HashMap<Partition, Set<Partition>>();
    protected final @NonNull Set<@NonNull Partition> externalPredecessors = new HashSet<Partition>();
    protected final @NonNull Set<@NonNull TraceClassAnalysis<@NonNull Partition>> traceClassAnalyses;
    protected final @NonNull Set<@NonNull TracePropertyAnalysis<@NonNull Partition>> tracePropertyAnalyses;
    private @Nullable List<@NonNull Iterable<@NonNull Partition>> partitionSchedule = null;
    private @Nullable List<@NonNull Collection<@NonNull Region>> regionSchedule = null;

    public CyclicPartition(@NonNull TransformationPartitioner transformationPartitioner, @NonNull String name, @NonNull CyclicPartitionsAnalysis cyclesAnalysis, @NonNull Set<@NonNull Partition> partitions, @NonNull Map<@NonNull Partition, @NonNull Set<@NonNull Partition>> partition2predecessors, @NonNull Set<@NonNull TraceClassAnalysis<@NonNull Partition>> traceClassAnalyses, @NonNull Set<@NonNull TracePropertyAnalysis<@NonNull Partition>> tracePropertyAnalyses) {
        super(transformationPartitioner, (Region)QVTscheduleFactory.eINSTANCE.createCyclicMappingRegion());
        this.name = name;
        this.cyclesAnalysis = cyclesAnalysis;
        this.partitions = partitions;
        for (Partition partition : partitions) {
            HashSet<@NonNull E> internalPredecessors = new HashSet(partition2predecessors.get(partition));
            this.externalPredecessors.addAll(internalPredecessors);
            internalPredecessors.remove(partition);
            internalPredecessors.retainAll(partitions);
            this.partition2predecessors.put(partition, internalPredecessors);
        }
        this.externalPredecessors.removeAll(partitions);
        this.traceClassAnalyses = traceClassAnalyses;
        this.tracePropertyAnalyses = tracePropertyAnalyses;
        assert (!partitions.isEmpty());
    }

    @Override
    public void analyzePartition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull MappingRegion createMicroMappingRegion(int partitionNumber) {
        throw new UnsupportedOperationException();
    }

    public @NonNull Iterable<@NonNull MappingRegion> createMicroMappingRegions(@NonNull Region partitionRegion) {
        this.getRegionSchedule();
        ArrayList<@NonNull MappingRegion> microMappingRegions = new ArrayList<MappingRegion>();
        for (Partition partition : this.partitions) {
            if (partition instanceof CyclicPartition) {
                Iterables.addAll(microMappingRegions, ((CyclicPartition)partition).createMicroMappingRegions(partitionRegion));
                continue;
            }
            microMappingRegions.add(partition.getMicroMappingRegion());
        }
        return microMappingRegions;
    }

    @Override
    public int getDepth() {
        assert (this.parallelScheduleDepth >= 0);
        return this.parallelScheduleDepth;
    }

    @Override
    public @NonNull Set<@NonNull Partition> getExplicitPredecessors() {
        return this.externalPredecessors;
    }

    @Override
    public @NonNull MappingRegion getMicroMappingRegion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    protected @NonNull Iterable<@NonNull Edge> getPartialEdges() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected @NonNull Iterable<@NonNull Node> getPartialNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull List<@NonNull Iterable<@NonNull Partition>> getPartitionSchedule() {
        List<@NonNull Iterable<@NonNull Partition>> partitionSchedule2 = this.partitionSchedule;
        if (partitionSchedule2 == null) {
            Set<@NonNull Partition> keys = this.partition2predecessors.keySet();
            this.partitionSchedule = partitionSchedule2 = Collections.singletonList(keys);
            for (Partition partition : this.partitions) {
                if (!(partition instanceof InternallyAcyclicPartition)) continue;
                ((InternallyAcyclicPartition)((Object)partition)).getPartitionSchedule();
            }
        }
        return partitionSchedule2;
    }

    @Override
    public @NonNull Iterable<@NonNull Partition> getPartitions() {
        return this.partitions;
    }

    @Override
    public @NonNull List<@NonNull Collection<@NonNull Region>> getRegionSchedule() {
        List<@NonNull Collection<@NonNull Region>> regionSchedule2 = this.regionSchedule;
        if (regionSchedule2 == null) {
            this.regionSchedule = regionSchedule2 = new ArrayList<Collection<Region>>();
            for (Iterable<Partition> concurrentPartitions : this.getPartitionSchedule()) {
                ArrayList<@NonNull MappingRegion> concurrentRegions = new ArrayList<MappingRegion>();
                for (Partition partition : concurrentPartitions) {
                    Region partitionRegion = partition.getRegion();
                    int partitionNumber = partitionRegion.getNextPartitionNumber();
                    concurrentRegions.add(partition.createMicroMappingRegion(partitionNumber));
                }
                regionSchedule2.add(concurrentRegions);
            }
        }
        return regionSchedule2;
    }

    @Override
    public @NonNull Iterable<@NonNull TraceClassAnalysis<@NonNull Partition>> getTraceClassAnalyses() {
        return this.traceClassAnalyses;
    }

    @Override
    public @NonNull Iterable<@NonNull TracePropertyAnalysis<@NonNull Partition>> getTracePropertyAnalyses() {
        return this.tracePropertyAnalyses;
    }

    @Override
    public void setDepth(int parallelScheduleDepth) {
        this.parallelScheduleDepth = parallelScheduleDepth;
    }

    public @NonNull String toString() {
        return this.name;
    }
}

