/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.apidocs.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.recommenders.apidocs.rcp.ApidocProvider;
import org.eclipse.recommenders.apidocs.rcp.JavaSelectionSubscriber;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Pair;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.swt.widgets.Composite;

public class SubscriptionManager {
    private final Multimap<Subscription, Pair<ApidocProvider, Method>> subscriptions = LinkedHashMultimap.create();

    @Inject
    public SubscriptionManager(List<ApidocProvider> providers) {
        Checks.ensureIsNotNull(providers);
        for (ApidocProvider p : providers) {
            this.register(p);
        }
    }

    private void register(ApidocProvider provider) {
        Set<Pair<Method, JavaSelectionSubscriber>> annotatedMethods = this.findAnnotatedMethods(provider);
        if (annotatedMethods.isEmpty()) {
            Throws.throwIllegalArgumentException((String)"no listeners found");
        }
        for (Pair<Method, JavaSelectionSubscriber> t : annotatedMethods) {
            this.addSubscription(provider, (Method)t.getFirst(), (JavaSelectionSubscriber)t.getSecond());
        }
    }

    private Set<Pair<Method, JavaSelectionSubscriber>> findAnnotatedMethods(ApidocProvider provider) {
        LinkedHashSet<Pair<Method, JavaSelectionSubscriber>> methods = new LinkedHashSet<Pair<Method, JavaSelectionSubscriber>>();
        Class<?> clazz = provider.getClass();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            JavaSelectionSubscriber annotation = m.getAnnotation(JavaSelectionSubscriber.class);
            if (annotation != null) {
                SubscriptionManager.ensureCorrectMethodSignature(m);
                methods.add((Pair<Method, JavaSelectionSubscriber>)Pair.newPair((Object)m, (Object)annotation));
            }
            ++n2;
        }
        return methods;
    }

    private static void ensureCorrectMethodSignature(Method m) {
        Class<?>[] params = m.getParameterTypes();
        SubscriptionManager.ensureParameterLengthIsThree(params, m);
        SubscriptionManager.ensureFirstParameterTypeIsJavaElement(params, m);
        SubscriptionManager.ensureSecondParameterTypeIsJavaSelectionEvent(params, m);
        SubscriptionManager.ensureThirdParameterTypeIsComposite(params, m);
    }

    private static void ensureParameterLengthIsThree(Class<?>[] params, Method m) {
        if (params.length != 3) {
            Throws.throwIllegalArgumentException((String)"error in %s: at least 3 parameters expected", (Object[])new Object[]{m.toGenericString()});
        }
    }

    private static void ensureFirstParameterTypeIsJavaElement(Class<?>[] params, Method m) {
        if (!IJavaElement.class.isAssignableFrom(params[0])) {
            Throws.throwIllegalArgumentException((String)"error in %s: first parameter needs to be %s or a subclass", (Object[])new Object[]{m.toGenericString(), IJavaElement.class.getName()});
        }
    }

    private static void ensureSecondParameterTypeIsJavaSelectionEvent(Class<?>[] params, Method m) {
        if (!JavaElementSelectionEvent.class.isAssignableFrom(params[1])) {
            Throws.throwIllegalArgumentException((String)"error in %s: second parameter needs to be %s or a subclass", (Object[])new Object[]{m.toGenericString(), JavaElementSelectionEvent.class.getName()});
        }
    }

    private static void ensureThirdParameterTypeIsComposite(Class<?>[] params, Method m) {
        if (!Composite.class.isAssignableFrom(params[2])) {
            Throws.throwIllegalArgumentException((String)"error in %s: third parameter needs to be %s or a subclass", (Object[])new Object[]{m.toGenericString(), Composite.class.getName()});
        }
    }

    private void addSubscription(ApidocProvider provider, Method method, JavaSelectionSubscriber annotation) {
        JavaElementSelectionEvent.JavaElementSelectionLocation[] locs = annotation.value();
        Class<?> javaElementType = method.getParameterTypes()[0];
        Pair subscriber = Pair.newPair((Object)provider, (Object)method);
        if (locs.length == 0) {
            Subscription subscription = Subscription.create(javaElementType, null);
            this.subscriptions.put((Object)subscription, (Object)subscriber);
        } else {
            JavaElementSelectionEvent.JavaElementSelectionLocation[] javaElementSelectionLocationArray = locs;
            int n = locs.length;
            int n2 = 0;
            while (n2 < n) {
                JavaElementSelectionEvent.JavaElementSelectionLocation loc = javaElementSelectionLocationArray[n2];
                Subscription subscription = Subscription.create(javaElementType, loc);
                this.subscriptions.put((Object)subscription, (Object)subscriber);
                ++n2;
            }
        }
    }

    public Optional<Method> findSubscribedMethod(ApidocProvider provider, JavaElementSelectionEvent selection) {
        for (Subscription s : this.subscriptions.keySet()) {
            if (!s.isInterestedIn(selection)) continue;
            for (Pair t : this.subscriptions.get((Object)s)) {
                if (!provider.equals(t.getFirst())) continue;
                return Optional.of((Object)((Method)t.getSecond()));
            }
        }
        return Optional.absent();
    }

    public static class Subscription {
        private Class<?> interestedJavaElementClass;
        private JavaElementSelectionEvent.JavaElementSelectionLocation interestedLocation;

        public static Subscription create(Class<?> clazz, JavaElementSelectionEvent.JavaElementSelectionLocation loc) {
            Subscription subscription = new Subscription();
            subscription.interestedJavaElementClass = clazz;
            subscription.interestedLocation = loc;
            return subscription;
        }

        public boolean isInterestedIn(JavaElementSelectionEvent selection) {
            return this.isInterestedIn(selection.getElement()) && this.isInterestedIn(selection.getLocation());
        }

        private boolean isInterestedIn(IJavaElement element) {
            return this.interestedJavaElementClass.isAssignableFrom(element.getClass());
        }

        private boolean isInterestedIn(JavaElementSelectionEvent.JavaElementSelectionLocation firedLoc) {
            return this.matchesAllLocations() || this.matchesFiredLocation(firedLoc);
        }

        private boolean matchesFiredLocation(JavaElementSelectionEvent.JavaElementSelectionLocation firedLoc) {
            return this.interestedLocation.equals((Object)firedLoc);
        }

        private boolean matchesAllLocations() {
            return this.interestedLocation == null;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }
    }
}

