/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.examples.models;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.recommenders.models.DownloadCallback;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;

public class UsingModelRepository {
    private static final boolean PREFETCH = true;
    private static final boolean FORCE_DOWNLOAD = true;

    public void getCachedModelArchive(ModelCoordinate mc, IModelRepository repository) {
        repository.getLocation(mc, true);
    }

    public void updateModelArchiveIfNecessary(ModelCoordinate mc, IModelRepository repository) {
        Optional<File> modelArchive = repository.resolve(mc, false);
        if (modelArchive.isPresent()) {
            modelArchive.get();
        }
    }

    public void updateModelArchiveIfNecessaryInBackground(final ModelCoordinate mc, final IModelRepository repository) {
        final DownloadCallback callback = new DownloadCallback(){

            @Override
            public void downloadInitiated(String path) {
                System.out.println("Now downloading " + path);
            }
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.submit(new Callable<Optional<File>>(){

            @Override
            public Optional<File> call() throws Exception {
                return repository.resolve(mc, false, callback);
            }
        });
    }

    void deleteCachedModelArchive(ModelCoordinate mc, IModelRepository repository) throws IOException {
    }

    void deleteIndex(IModelRepository repository) throws IOException {
    }
}

