/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner.statement;

import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.execution.PriorityComparator;
import org.eclipse.reddeer.junit.extensionpoint.IBeforeTest;
import org.eclipse.reddeer.junit.internal.runner.statement.AbstractStatementWithScreenshot;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class RunIBeforeClassExtensions
extends AbstractStatementWithScreenshot {
    private static final Logger log = Logger.getLogger(RunIBeforeClassExtensions.class);
    private final List<IBeforeTest> befores;

    public RunIBeforeClassExtensions(String config, Statement next, TestClass testClass, List<IBeforeTest> befores) {
        super(config, next, testClass, null, null);
        this.befores = befores;
    }

    public void evaluate() throws Throwable {
        Object before = null;
        log.debug("Run before class extensions for test class " + this.testClass.getJavaClass().getName());
        try {
            this.befores.sort(new PriorityComparator());
            for (IBeforeTest bfr : this.befores) {
                before = bfr;
                if (!before.hasToRun()) continue;
                log.debug("Run method runBeforeTestClass() of class " + before.getClass().getCanonicalName());
                before.runBeforeTestClass(this.config, this.testClass);
            }
        }
        catch (Throwable e) {
            if (ScreenshotCapturer.shouldCaptureScreenshotOnException(e)) {
                log.error("Run method runBeforeTestClass() of class " + before.getClass().getCanonicalName() + " failed", e);
                this.createScreenshot("BeforeClassExt", before.getClass());
            }
            throw e;
        }
        this.nextStatement.evaluate();
    }
}

