/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.jdt.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.AddUnimplementedConstructorsAction;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jdt.ui.actions.OverrideMethodsAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraintBehavior;
import org.eclipse.sapphire.java.JavaTypeConstraintService;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.PropertyEditorActionHandler;
import org.eclipse.sapphire.ui.forms.PropertyEditorCondition;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public abstract class JavaTypeCreateActionHandler
extends PropertyEditorActionHandler {
    @Text(value="Java Convention Violation")
    private static LocalizableText discourageDialogTitle;
    @Text(value="The use of the default package is discouraged. Do you want to proceed?")
    private static LocalizableText discourageDefaultPackage;
    @Text(value="Type name is discourage. By convention, Java type names should start with an upper case letter. Do you want to proceed?")
    private static LocalizableText discourageLowerCase;
    private final JavaTypeKind kind;

    static {
        LocalizableText.init(JavaTypeCreateActionHandler.class);
    }

    public JavaTypeCreateActionHandler(JavaTypeKind kind) {
        this.kind = kind;
    }

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        final Property property = this.property();
        FilteredListener<PropertyEvent> listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                JavaTypeCreateActionHandler.this.refreshEnablementState();
            }
        };
        property.attach((Listener)listener);
        this.attach(new Listener((Listener)listener){
            private final /* synthetic */ Listener val$listener;
            {
                this.val$listener = listener;
            }

            public void handle(Event event) {
                if (event instanceof DisposeEvent) {
                    property.detach(this.val$listener);
                }
            }
        });
    }

    protected Object run(Presentation context) {
        Shell shell = ((FormComponentPresentation)context).shell();
        final Value javaTypeNameValue = (Value)this.property();
        if (javaTypeNameValue.malformed()) {
            return null;
        }
        final JavaTypeName javaTypeName = (JavaTypeName)javaTypeNameValue.content();
        if (javaTypeName.pkg() == null && !MessageDialog.openConfirm((Shell)shell, (String)discourageDialogTitle.text(), (String)discourageDefaultPackage.text())) {
            return null;
        }
        if (!Character.isUpperCase(javaTypeName.simple().charAt(0)) && !MessageDialog.openConfirm((Shell)shell, (String)discourageDialogTitle.text(), (String)discourageLowerCase.text())) {
            return null;
        }
        JavaTypeConstraintService javaTypeConstraintService = (JavaTypeConstraintService)javaTypeNameValue.service(JavaTypeConstraintService.class);
        IJavaProject jproj = (IJavaProject)javaTypeNameValue.element().adapt(IJavaProject.class);
        JavaTypeName expectedBaseClassTemp = null;
        final ArrayList<JavaTypeName> expectedInterfaces = new ArrayList<JavaTypeName>();
        if (javaTypeConstraintService != null) {
            JavaTypeConstraintBehavior behavior = javaTypeConstraintService.behavior();
            SortedSet types = javaTypeConstraintService.types();
            Iterator iterator = types.iterator();
            int i = 0;
            int n = behavior == JavaTypeConstraintBehavior.ALL ? types.size() : Math.min(1, types.size());
            while (i < n) {
                String typeName = (String)iterator.next();
                try {
                    IType type = jproj.findType(typeName.replace('$', '.'));
                    if (type != null && type.exists()) {
                        if (type.isClass()) {
                            expectedBaseClassTemp = new JavaTypeName(typeName);
                        } else if (type.isInterface()) {
                            expectedInterfaces.add(new JavaTypeName(typeName));
                        }
                    }
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
                ++i;
            }
        }
        final JavaTypeName expectedBaseClass = expectedBaseClassTemp;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", 7);
                JavaTypeKind kind = JavaTypeCreateActionHandler.this.kind;
                StringBuilder buf = new StringBuilder();
                if (javaTypeName.pkg() != null) {
                    buf.append("package ");
                    buf.append(javaTypeName.pkg());
                    buf.append(";\n\n");
                }
                ArrayList<JavaTypeName> imports = new ArrayList<JavaTypeName>();
                imports.add(javaTypeName);
                String base = null;
                if (kind == JavaTypeKind.CLASS && expectedBaseClass != null) {
                    base = JavaTypeCreateActionHandler.deriveSafeLocalName(expectedBaseClass, imports);
                }
                ArrayList<String> interfaces = new ArrayList<String>();
                if (kind == JavaTypeKind.CLASS || kind == JavaTypeKind.INTERFACE) {
                    for (JavaTypeName t : expectedInterfaces) {
                        interfaces.add(JavaTypeCreateActionHandler.deriveSafeLocalName(t, imports));
                    }
                }
                imports.remove(javaTypeName);
                if (!imports.isEmpty()) {
                    for (JavaTypeName t : imports) {
                        buf.append("import ");
                        buf.append(t.qualified().replace('$', '.'));
                        buf.append(";\n");
                    }
                    buf.append('\n');
                }
                buf.append("public ");
                switch (kind) {
                    case ANNOTATION: {
                        buf.append("@interface");
                        break;
                    }
                    case ENUM: {
                        buf.append("enum");
                        break;
                    }
                    case INTERFACE: {
                        buf.append("interface");
                        break;
                    }
                    default: {
                        buf.append("class");
                    }
                }
                buf.append(' ');
                buf.append(javaTypeName.simple());
                if (base != null) {
                    buf.append(" extends ");
                    buf.append(base);
                }
                if (!interfaces.isEmpty()) {
                    buf.append(kind == JavaTypeKind.INTERFACE ? " extends " : " implements ");
                    boolean first = true;
                    for (String implementsType : interfaces) {
                        if (first) {
                            first = false;
                        } else {
                            buf.append(", ");
                        }
                        buf.append(implementsType);
                    }
                }
                buf.append("\n{\n}\n");
                monitor.worked(1);
                IProject proj = (IProject)javaTypeNameValue.element().adapt(IProject.class);
                IJavaProject jproj = JavaCore.create((IProject)proj);
                try {
                    IPackageFragmentRoot src = JavaTypeCreateActionHandler.this.src(jproj);
                    IPackageFragment pkg = src.createPackageFragment(javaTypeName.pkg() == null ? "" : javaTypeName.pkg(), true, null);
                    ICompilationUnit cu = pkg.createCompilationUnit(String.valueOf(javaTypeName.simple()) + ".java", buf.toString(), true, null);
                    cu.save(null, true);
                    monitor.worked(1);
                    IEditorPart editor = JavaUI.openInEditor((IJavaElement)cu);
                    IWorkbenchPartSite site = editor.getSite();
                    monitor.worked(1);
                    if (kind == JavaTypeKind.CLASS) {
                        IType type = cu.getType(javaTypeName.simple());
                        ASTParser parser = JavaTypeCreateActionHandler.createAstParser();
                        parser.setResolveBindings(true);
                        parser.setSource(cu);
                        CompilationUnit ast = (CompilationUnit)parser.createAST(null);
                        ASTNode node = NodeFinder.perform((ASTNode)ast, (ISourceRange)type.getNameRange());
                        while (!(node instanceof AbstractTypeDeclaration)) {
                            node = node.getParent();
                        }
                        ITypeBinding typeBinding = ((AbstractTypeDeclaration)node).resolveBinding();
                        IWorkspaceRunnable addUnimplementedConstructorsOp = AddUnimplementedConstructorsAction.createRunnable((CompilationUnit)ast, (ITypeBinding)typeBinding, null, (int)-1, (boolean)false, (int)1, (boolean)false);
                        addUnimplementedConstructorsOp.run(null);
                        IWorkspaceRunnable overrideMethodsOp = OverrideMethodsAction.createRunnable((CompilationUnit)ast, (ITypeBinding)typeBinding, null, (int)-1, (boolean)false);
                        overrideMethodsOp.run(null);
                    }
                    monitor.worked(1);
                    OrganizeImportsAction organizeImportsAction = new OrganizeImportsAction((IWorkbenchSite)site);
                    organizeImportsAction.run(cu);
                    monitor.worked(1);
                    FormatAllAction formatAllAction = new FormatAllAction((IWorkbenchSite)site);
                    formatAllAction.runOnMultiple(new ICompilationUnit[]{cu});
                    monitor.worked(1);
                    editor.doSave(null);
                    monitor.worked(1);
                }
                catch (CoreException e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(false, false, op);
        }
        catch (InvocationTargetException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        catch (InterruptedException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return null;
    }

    protected boolean computeEnablementState() {
        boolean enabled = super.computeEnablementState();
        if (enabled) {
            String typeName;
            ReferenceValue ref = (ReferenceValue)this.property();
            enabled = false;
            if (!ref.malformed() && (typeName = ref.text()) != null && typeName.indexOf(36) == -1 && ref.target() == null) {
                enabled = true;
            }
        }
        return enabled;
    }

    private final IPackageFragmentRoot src(IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                return root;
            }
            ++n2;
        }
        return null;
    }

    private static String deriveSafeLocalName(JavaTypeName type, Collection<JavaTypeName> imports) {
        boolean collision = false;
        for (JavaTypeName n : imports) {
            if (!n.simple().equals(type.simple())) continue;
            collision = true;
            break;
        }
        if (collision) {
            return type.qualified().replace('$', '.');
        }
        imports.add(type);
        return type.simple();
    }

    private static ASTParser createAstParser() {
        int level = JavaTypeCreateActionHandler.isJavaLanguageSpecSupported(8) ? 8 : (JavaTypeCreateActionHandler.isJavaLanguageSpecSupported(4) ? 4 : 3);
        return ASTParser.newParser((int)level);
    }

    private static boolean isJavaLanguageSpecSupported(int version) {
        try {
            AST.class.getField("JLS" + String.valueOf(version));
            return true;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
    }

    protected static abstract class Condition
    extends PropertyEditorCondition {
        protected Condition() {
        }

        protected final boolean evaluate(PropertyEditorPart part) {
            Property property = part.property();
            if (property instanceof Value && property.definition().isOfType(JavaTypeName.class)) {
                Reference referenceAnnotation = (Reference)property.definition().getAnnotation(Reference.class);
                return referenceAnnotation != null && referenceAnnotation.target() == JavaType.class && this.evaluate((JavaTypeConstraintService)property.service(JavaTypeConstraintService.class)) && property.element().adapt(IJavaProject.class) != null;
            }
            return false;
        }

        protected abstract boolean evaluate(JavaTypeConstraintService var1);
    }
}

