/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.business.internal.diagramtype;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ObservationPoint;
import org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters.CollapseUpdater;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.ICollapseMode;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class SequenceCollapseUpdater
extends CollapseUpdater {
    private Predicate<DDiagramElement> specificCollapsePredicate = Predicates.or((Predicate[])new Predicate[]{AbstractNodeEvent.viewpointElementPredicate(), Lifeline.viewpointElementPredicate(), ObservationPoint.viewpointElementPredicate()});

    protected void synchronizeCollapseFiltersAndGMFBounds(DDiagramElement element, Option<Node> optionalNode, boolean add, Class<? extends CollapseFilter> kindOfFilter) {
        if (InstanceRole.viewpointElementPredicate().apply((Object)element)) {
            return;
        }
        super.synchronizeCollapseFiltersAndGMFBounds(element, optionalNode, add, kindOfFilter);
    }

    public void collapseBounds(Node node, DDiagramElement element) {
        if (!this.specificCollapsePredicate.apply((Object)element)) {
            super.collapseBounds(node, element);
        } else {
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (layoutConstraint instanceof Bounds) {
                Bounds bounds = (Bounds)layoutConstraint;
                Bounds newBounds = NotationFactory.eINSTANCE.createBounds();
                newBounds.setX(bounds.getX() + bounds.getWidth() / 2);
                newBounds.setWidth(ICollapseMode.COLLAPSED_DIMENSION.width);
                int newY = bounds.getY();
                int newHeight = bounds.getHeight();
                if (ObservationPoint.notationPredicate().apply((Object)node)) {
                    newY = bounds.getY() + bounds.getHeight() / 2;
                    newHeight = ICollapseMode.COLLAPSED_DIMENSION.height;
                }
                newBounds.setY(newY);
                newBounds.setHeight(newHeight);
                node.setLayoutConstraint((LayoutConstraint)newBounds);
            }
        }
    }

    public Option<Bounds> getExpandedBounds(Node node, DDiagramElement element) {
        CollapseFilter filter;
        Object optionalBounds = !this.specificCollapsePredicate.apply((Object)element) ? super.getExpandedBounds(node, element) : ((filter = (CollapseFilter)Iterables.getFirst((Iterable)Iterables.filter((Iterable)element.getGraphicalFilters(), CollapseFilter.class), null)) != null ? this.getExpandedBounds(node, new Dimension(filter.getWidth(), filter.getHeight())) : Options.newNone());
        return optionalBounds;
    }

    public Option<Bounds> getExpandedBounds(Node node, Dimension expandedSize) {
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        if (layoutConstraint instanceof Bounds) {
            Bounds bounds = (Bounds)layoutConstraint;
            Bounds newBounds = NotationFactory.eINSTANCE.createBounds();
            newBounds.setX(bounds.getX() - expandedSize.width / 2);
            int newY = bounds.getY();
            if (ObservationPoint.notationPredicate().apply((Object)node)) {
                newY = bounds.getY() - expandedSize.height / 2;
            }
            newBounds.setY(newY);
            newBounds.setWidth(expandedSize.width);
            newBounds.setHeight(expandedSize.height);
            return Options.newSome((Object)newBounds);
        }
        return Options.newNone();
    }
}

