/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeBeginNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEndNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.locator.EdgeLabelQuery;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class SnapBackDistantLabelsMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("12.1.0.201706291600");
    private static final int LABEL_UPPER_LIMIT = 1000;
    private static final int LABEL_LOWER_LIMIT = 250;
    private static final int NODES_LIMIT = 1000000;
    private static final int NODES_LIMIT_MOVE = 5000;
    private static final String NEGATIVE_X_KEY = "-x";
    private static final String POSITIVE_X_KEY = "+x";
    private static final String NEGATIVE_Y_KEY = "-y";
    private static final String POSITIVE_Y_KEY = "+y";

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            this.initializeSnapBackPositionMap();
            boolean isModified = false;
            StringBuilder sb = new StringBuilder(Messages.SnapBackDistantLabelsMigrationParticipant_title);
            ArrayList<Node> distantEdgeLabels = new ArrayList<Node>();
            for (DView dView : dAnalysis.getOwnedViews()) {
                for (DDiagram dDiagram : Iterables.filter((Iterable)new DViewQuery(dView).getLoadedRepresentations(), DDiagram.class)) {
                    List<Node> currentDistantEdgeLabels = this.getDistantEdgeLabels(dDiagram);
                    distantEdgeLabels.addAll(currentDistantEdgeLabels);
                    if (currentDistantEdgeLabels.size() <= 0) continue;
                    isModified = true;
                    if (currentDistantEdgeLabels.size() > 1) {
                        sb.append(MessageFormat.format(Messages.SnapBackDistantLabelsMigrationParticipant_severalLabelsSnapBacked, currentDistantEdgeLabels.size(), dDiagram.getName()));
                    } else {
                        sb.append(MessageFormat.format(Messages.SnapBackDistantLabelsMigrationParticipant_oneLabelSnapBacked, dDiagram.getName()));
                    }
                    boolean nodesMoved = false;
                    Map<String, Map<Node, Integer>> currentnodesWithExtremeLocation = this.getNodesWithExtremeLocation(dDiagram);
                    for (String key : currentnodesWithExtremeLocation.keySet()) {
                        nodesMoved = NEGATIVE_X_KEY.equals(key) ? this.moveNodesX(currentnodesWithExtremeLocation.get(key), false) : (POSITIVE_X_KEY.equals(key) ? this.moveNodesX(currentnodesWithExtremeLocation.get(key), true) : (NEGATIVE_Y_KEY.equals(key) ? this.moveNodesY(currentnodesWithExtremeLocation.get(key), false) : this.moveNodesY(currentnodesWithExtremeLocation.get(key), true)));
                    }
                    if (!nodesMoved) continue;
                    sb.append(Messages.SnapBackDistantLabelsMigrationParticipant_nodesMoved);
                }
            }
            for (Node distantEdgeLabel : distantEdgeLabels) {
                Point offset = LabelEditPart.getSnapBackPosition((String)distantEdgeLabel.getType());
                if (offset == null) continue;
                ViewUtil.setStructuralFeatureValue((View)distantEdgeLabel, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)offset.x);
                ViewUtil.setStructuralFeatureValue((View)distantEdgeLabel, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)offset.y);
            }
            if (isModified) {
                DiagramPlugin.getDefault().logInfo(sb.toString());
            }
        }
    }

    protected boolean moveNodesX(Map<Node, Integer> nodesWithExtremeLocation, boolean isPositive) {
        return this.moveNodes(nodesWithExtremeLocation, isPositive, (input, newValue) -> input.setX(newValue.intValue()));
    }

    protected boolean moveNodesY(Map<Node, Integer> nodesWithExtremeLocation, boolean isPositive) {
        return this.moveNodes(nodesWithExtremeLocation, isPositive, (input, newValue) -> input.setY(newValue.intValue()));
    }

    protected boolean moveNodes(Map<Node, Integer> nodesWithExtremeLocation, boolean isPositive, Setter<Location, Integer> setter) {
        boolean nodesMoved = false;
        int min = -1000000;
        int max = Integer.MIN_VALUE;
        if (isPositive) {
            min = Integer.MAX_VALUE;
            max = 1000000;
        }
        for (Integer coordinate : nodesWithExtremeLocation.values()) {
            nodesMoved = true;
            if (coordinate < min) {
                min = coordinate;
            }
            if (coordinate <= max) continue;
            max = coordinate;
        }
        int delta = max - min;
        if (delta < 1000000) {
            for (Map.Entry<Node, Integer> entry : nodesWithExtremeLocation.entrySet()) {
                if (isPositive) {
                    setter.set((Location)entry.getKey().getLayoutConstraint(), entry.getValue() - max - 5000);
                    continue;
                }
                setter.set((Location)entry.getKey().getLayoutConstraint(), entry.getValue() - min + 5000);
            }
        } else {
            for (Map.Entry<Node, Integer> entry : nodesWithExtremeLocation.entrySet()) {
                if (isPositive) {
                    setter.set((Location)entry.getKey().getLayoutConstraint(), -5000);
                    continue;
                }
                setter.set((Location)entry.getKey().getLayoutConstraint(), 5000);
            }
        }
        return nodesMoved;
    }

    private void initializeSnapBackPositionMap() {
        new DEdgeNameEditPart(null);
        new DEdgeBeginNameEditPart(null);
        new DEdgeEndNameEditPart(null);
    }

    private List<Node> getDistantEdgeLabels(DDiagram dDiagram) {
        ArrayList<Node> distantEdgeLabels = new ArrayList<Node>();
        for (Edge edge : this.getEdges(dDiagram)) {
            for (Object child : edge.getChildren()) {
                if (!(child instanceof Node) || !new ViewQuery((View)((Node)child)).isForEdgeNameEditPart() || !this.isLabelDistant(edge, (Node)child)) continue;
                distantEdgeLabels.add((Node)child);
            }
        }
        return distantEdgeLabels;
    }

    private Map<String, Map<Node, Integer>> getNodesWithExtremeLocation(DDiagram dDiagram) {
        HashMap<Node, Integer> nodesWithExtremeNegativeXLocation = new HashMap<Node, Integer>();
        HashMap<Node, Integer> nodesWithExtremePositiveXLocation = new HashMap<Node, Integer>();
        HashMap<Node, Integer> nodesWithExtremeNegativeYLocation = new HashMap<Node, Integer>();
        HashMap<Node, Integer> nodesWithExtremePositiveYLocation = new HashMap<Node, Integer>();
        for (Node node : this.getNodes(dDiagram)) {
            if (!(node.getLayoutConstraint() instanceof Location)) continue;
            Location location = (Location)node.getLayoutConstraint();
            Point point = new Point(location.getX(), location.getY());
            if (Math.abs(location.getX()) > 1000000) {
                if (location.getX() > 0) {
                    nodesWithExtremePositiveXLocation.put(node, point.x());
                } else {
                    nodesWithExtremeNegativeXLocation.put(node, point.x());
                }
            }
            if (Math.abs(location.getY()) <= 1000000) continue;
            if (location.getY() > 0) {
                nodesWithExtremePositiveYLocation.put(node, point.y());
                continue;
            }
            nodesWithExtremeNegativeYLocation.put(node, point.y());
        }
        HashMap<String, Map<Node, Integer>> result = new HashMap<String, Map<Node, Integer>>();
        result.put(NEGATIVE_X_KEY, nodesWithExtremeNegativeXLocation);
        result.put(POSITIVE_X_KEY, nodesWithExtremePositiveXLocation);
        result.put(NEGATIVE_Y_KEY, nodesWithExtremeNegativeYLocation);
        result.put(POSITIVE_Y_KEY, nodesWithExtremePositiveYLocation);
        return result;
    }

    private boolean isLabelDistant(Edge edge, Node edgeLabel) {
        Location location;
        boolean isLabelDistant = false;
        if (edgeLabel.getLayoutConstraint() instanceof Location && (Math.abs((location = (Location)edgeLabel.getLayoutConstraint()).getX()) > 250 || Math.abs(location.getY()) > 250)) {
            boolean bl = isLabelDistant = Math.abs(location.getX()) > 1000 || Math.abs(location.getY()) > 1000;
            if (!isLabelDistant) {
                try {
                    ArrayList<Point> result = new ArrayList<Point>();
                    PointList ptList = new PointList();
                    Anchor anchor = edge.getSourceAnchor();
                    if (anchor instanceof IdentityAnchor && edge.getSource() instanceof Node) {
                        PrecisionPoint relativeReference = BaseSlidableAnchor.parseTerminalString((String)((IdentityAnchor)anchor).getId());
                        Rectangle sourceBounds = new NodeQuery((Node)edge.getSource()).getHandleBounds();
                        PrecisionPoint srcAnchorLoc = new PrecisionPoint(relativeReference.preciseX() * (double)sourceBounds.width() + (double)sourceBounds.x(), relativeReference.preciseY() * (double)sourceBounds.height() + (double)sourceBounds.y());
                        RelativeBendpoints bp = (RelativeBendpoints)edge.getBendpoints();
                        int i = 0;
                        while (i < bp.getPoints().size()) {
                            RelativeBendpoint rbp = (RelativeBendpoint)bp.getPoints().get(i);
                            Point fromSrc = srcAnchorLoc.getTranslated(rbp.getSourceX(), rbp.getSourceY());
                            result.add(fromSrc);
                            ptList.addPoint(fromSrc);
                            ++i;
                        }
                        Point refPoint = PointListUtilities.calculatePointRelativeToLine((PointList)ptList, (int)0, (int)this.getLocationOfReference(edgeLabel), (boolean)true);
                        Point labelCenter = EdgeLabelQuery.relativeCenterCoordinateFromOffset(ptList, refPoint, new Point(location.getX(), location.getY()));
                        List segments = PointListUtilities.getLineSegments((PointList)ptList);
                        LineSeg nearestSegment = PointListUtilities.getNearestSegment((List)segments, (int)labelCenter.x, (int)labelCenter.y);
                        double distance = nearestSegment.distanceToPoint(labelCenter.x(), labelCenter.y());
                        isLabelDistant = distance > nearestSegment.length() * 4.0;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return isLabelDistant;
    }

    private int getLocationOfReference(Node edgeLabel) {
        int locationOfRef = 50;
        int type = SiriusVisualIDRegistry.getVisualID(edgeLabel.getType());
        if (6002 == type) {
            locationOfRef = 15;
        } else if (6003 == type) {
            locationOfRef = 85;
        }
        return locationOfRef;
    }

    private Collection<Edge> getEdges(DDiagram dDiagram) {
        DDiagramGraphicalQuery query = new DDiagramGraphicalQuery(dDiagram);
        Option<Diagram> gmfDiagram = query.getAssociatedGMFDiagram();
        if (gmfDiagram.some()) {
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)((Diagram)gmfDiagram.get()).getEdges(), Edge.class));
        }
        return new ArrayList<Edge>();
    }

    private Collection<Node> getNodes(DDiagram dDiagram) {
        DDiagramGraphicalQuery query = new DDiagramGraphicalQuery(dDiagram);
        Option<Diagram> gmfDiagram = query.getAssociatedGMFDiagram();
        if (gmfDiagram.some()) {
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)((Diagram)gmfDiagram.get()).getChildren(), Node.class));
        }
        return new ArrayList<Node>();
    }

    public static interface Setter<F, T> {
        public void set(F var1, T var2);
    }
}

