/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Optional;
import java.util.WeakHashMap;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ITransparentFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ImageFigureWithAlpha;
import org.eclipse.sirius.diagram.ui.tools.api.figure.StyledFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.TransparentFigureGraphicsModifier;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.svg.SimpleImageTranscoder;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFigure
extends Figure
implements StyledFigure,
ITransparentFigure,
ImageFigureWithAlpha {
    private static final ImageCache CACHE = new ImageCache();
    private static final boolean CACHE_ENABLED = true;
    private static final boolean CACHE_SCALED_IMAGES = true;
    protected static final String IMAGE_NOT_FOUND_URI = MessageFormat.format("platform:/plugin/{0}/images/NotFound.svg", DiagramUIPlugin.getPlugin().getSymbolicName());
    protected static final String SEPARATOR = "|";
    private String uri;
    private int viewpointAlpha = 100;
    private boolean transparent;
    private boolean failedToLoadDocument;
    private SimpleImageTranscoder transcoder;
    private double initialAspectRatio = 1.0;
    protected boolean modeWithViewBox;
    protected static WeakHashMap<String, Document> documentsMap = new WeakHashMap();

    public SVGFigure() {
        this.setLayoutManager((LayoutManager)new XYLayout());
    }

    @Override
    public int getSiriusAlpha() {
        return this.viewpointAlpha;
    }

    @Override
    public boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public void setSiriusAlpha(int alpha) {
        this.viewpointAlpha = alpha;
    }

    @Override
    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    @Override
    public int getImageHeight() {
        return this.transcoder != null ? this.transcoder.getImageHeight() : 0;
    }

    @Override
    public int getImageWidth() {
        return this.transcoder != null ? this.transcoder.getImageWidth() : 0;
    }

    public double getImageAspectRatio() {
        return this.initialAspectRatio;
    }

    @Override
    public int getImageAlphaValue(int x, int y) {
        return this.transcoder != null ? this.transcoder.getImageAlphaValue(x, y) : 255;
    }

    public final String getURI() {
        return this.uri;
    }

    public final void setURI(String uri) {
        this.setURI(uri, true);
    }

    public void setURI(String uri, boolean loadOnDemand) {
        this.uri = uri;
        this.transcoder = null;
        this.failedToLoadDocument = false;
        if (loadOnDemand) {
            this.loadDocument();
        }
    }

    private void loadDocument() {
        Document document;
        this.transcoder = null;
        this.failedToLoadDocument = true;
        if (this.uri == null) {
            return;
        }
        String documentKey = this.getDocumentKey();
        if (documentsMap.containsKey(documentKey)) {
            document = documentsMap.get(documentKey);
        } else {
            document = this.createDocument();
            documentsMap.put(documentKey, document);
        }
        if (document != null) {
            this.transcoder = new SimpleImageTranscoder(document);
            this.failedToLoadDocument = false;
        }
    }

    private Document createDocument() {
        String parser = Optional.ofNullable(XMLResourceDescriptor.getXMLParserClassName()).orElse("org.apache.xerces.parsers.SAXParser");
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        return this.createDocument(factory, false);
    }

    private Document createDocument(SAXSVGDocumentFactory factory, boolean forceClassLoader) {
        if (forceClassLoader) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        try {
            Document document = factory.createDocument(this.uri);
            return document;
        }
        catch (IOException e) {
            boolean saxParserNotFound;
            boolean bl = saxParserNotFound = e.getMessage() != null && e.getMessage().contains("SAX2 driver class org.apache.xerces.parsers.SAXParser not found");
            if (!forceClassLoader && saxParserNotFound && Thread.currentThread().getContextClassLoader() == null) {
                Document document = this.createDocument(factory, true);
                return document;
            }
            DiagramPlugin.getDefault().logError(Messages.SVGFigure_loadError, (Throwable)e);
        }
        finally {
            if (forceClassLoader) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
        return null;
    }

    protected final Document getDocument() {
        if (this.failedToLoadDocument) {
            return null;
        }
        if (this.transcoder == null) {
            this.loadDocument();
        }
        return this.transcoder == null ? null : this.transcoder.getDocument();
    }

    public void contentChanged() {
        Document document = this.getDocument();
        this.modeWithViewBox = false;
        int i = 0;
        while (i < document.getChildNodes().getLength()) {
            String viewBoxValue;
            Node node = document.getChildNodes().item(i);
            if (node instanceof Element && !StringUtil.isEmpty((String)(viewBoxValue = ((Element)node).getAttribute("viewBox")))) {
                this.modeWithViewBox = true;
            }
            ++i;
        }
        if (this.transcoder != null) {
            this.transcoder.contentChanged();
            this.initialAspectRatio = this.transcoder.getAspectRatio();
        }
        this.repaint();
    }

    protected SimpleImageTranscoder getTranscoder() {
        return this.transcoder;
    }

    protected String getDocumentKey() {
        return this.uri;
    }

    protected String getKey(Graphics graphics) {
        int aaText = -1;
        try {
            aaText = graphics.getTextAntialias();
        }
        catch (Exception exception) {}
        StringBuffer result = new StringBuffer();
        result.append(this.getDocumentKey());
        result.append(SEPARATOR);
        result.append(this.getSiriusAlpha());
        result.append(SEPARATOR);
        result.append(aaText);
        result.append(SEPARATOR);
        PrecisionRectangle r = new PrecisionRectangle(this.getClientArea());
        if (graphics != null) {
            r.performScale(graphics.getAbsoluteScale());
        }
        result.append(r.width());
        result.append(SEPARATOR);
        result.append(r.height());
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintFigure(Graphics graphics) {
        TransparentFigureGraphicsModifier modifier = new TransparentFigureGraphicsModifier(this, graphics);
        modifier.pushState();
        Rectangle svgArea = this.getClientArea();
        PrecisionRectangle scaledArea = new PrecisionRectangle(svgArea);
        scaledArea.performScale(graphics.getAbsoluteScale());
        Image image = this.getImage(svgArea, graphics);
        if (image != null) {
            Image image2 = image;
            synchronized (image2) {
                if (!image.isDisposed()) {
                    if (this.modeWithViewBox) {
                        graphics.drawImage(image, 0, 0, scaledArea.width(), scaledArea.height(), svgArea.x(), svgArea.y(), svgArea.width(), svgArea.height());
                    } else {
                        double scaledWidth = (double)svgArea.width() * graphics.getAbsoluteScale();
                        double scaledHeight = scaledWidth / this.getImageAspectRatio();
                        if (scaledHeight / graphics.getAbsoluteScale() > (double)svgArea.height()) {
                            scaledHeight = (double)svgArea.height() * graphics.getAbsoluteScale();
                            scaledWidth = scaledHeight * this.getImageAspectRatio();
                        }
                        graphics.drawImage(image, 0, 0, (int)scaledWidth, (int)scaledHeight, svgArea.x(), svgArea.y(), svgArea.width(), svgArea.height());
                    }
                }
            }
        }
        modifier.popState();
    }

    protected Image getImage(Rectangle clientArea, Graphics graphics) {
        return CACHE.getImage(this, clientArea, graphics);
    }

    protected static boolean doRemoveFromCache(String documentKey) {
        if (!StringUtil.isEmpty((String)documentKey)) {
            return CACHE.doRemoveFromCache(documentKey) || documentsMap.remove(documentKey) != null;
        }
        return false;
    }

    private static class ImageCache {
        private static final int MAX_WEIGHT;
        private final Cache<String, Image> images = CacheBuilder.newBuilder().maximumWeight((long)MAX_WEIGHT).removalListener((RemovalListener)new ImageRemovalListener()).weigher((Weigher)new ImageWeigher()).build();

        static {
            int mb;
            String s = System.getProperty("org.eclipse.sirius.diagram.ui.svg.maxCacheSizeMB");
            try {
                mb = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                mb = 50;
            }
            MAX_WEIGHT = mb * 1024 * 1024;
        }

        private ImageCache() {
        }

        public synchronized Image getImage(SVGFigure fig, Rectangle clientArea, Graphics graphics) {
            String key = fig.getKey(graphics);
            Image result = (Image)this.images.getIfPresent((Object)key);
            if (result == null || result.isDisposed()) {
                if (fig.transcoder != null) {
                    result = fig.transcoder.render(fig, clientArea, graphics, true);
                }
                if (result != null) {
                    this.images.put((Object)key, (Object)result);
                }
            }
            return result;
        }

        public synchronized boolean doRemoveFromCache(String documentKey) {
            if (!StringUtil.isEmpty((String)documentKey)) {
                boolean remove = false;
                ArrayList<String> keyToRemove = new ArrayList<String>();
                for (String key : this.images.asMap().keySet()) {
                    if (!key.startsWith(documentKey)) continue;
                    keyToRemove.add(key);
                }
                for (String toRemove : keyToRemove) {
                    this.images.invalidate((Object)toRemove);
                    remove = true;
                }
                return remove;
            }
            return false;
        }

        private final class ImageRemovalListener
        implements RemovalListener<String, Image> {
            private ImageRemovalListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRemoval(RemovalNotification<String, Image> notification) {
                Image img;
                Image image = img = (Image)notification.getValue();
                synchronized (image) {
                    img.dispose();
                }
            }
        }

        private static final class ImageWeigher
        implements Weigher<String, Image> {
            private ImageWeigher() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int weigh(String key, Image value) {
                if (value != null) {
                    Image image = value;
                    synchronized (image) {
                        if (!value.isDisposed()) {
                            org.eclipse.swt.graphics.Rectangle bounds = value.getBounds();
                            return bounds.width * bounds.height * 4;
                        }
                    }
                }
                return 0;
            }
        }
    }
}

