/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableTreeViewer;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.utils.TreeColumnWidthQuery;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTableViewerManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;

public final class DTableEditorUtil {
    private DTableEditorUtil() {
    }

    public static void addNewColumn(AbstractDTableViewerManager treeViewerManager, int position, DColumn newColumn) {
        DTableTreeViewer dTableTreeViewer = (DTableTreeViewer)treeViewerManager.getTreeViewer();
        ((DTableViewerManager)treeViewerManager).addNewColumn(newColumn, position, true);
        TreeColumn[] columns = dTableTreeViewer.getTree().getColumns();
        if (columns.length > position) {
            boolean oldIsPropertiesUpdate = treeViewerManager.getEditor().isPropertiesUpdateEnabled();
            treeViewerManager.getEditor().enablePropertiesUpdate(false);
            columns[position].pack();
            treeViewerManager.getEditor().enablePropertiesUpdate(oldIsPropertiesUpdate);
        }
    }

    public static void updateViewerColumns(AbstractDTableViewerManager treeViewerManager, DTable dTable) {
        DTableTreeViewer dTableTreeViewer = (DTableTreeViewer)treeViewerManager.getTreeViewer();
        TreeColumn[] treeColumns = dTableTreeViewer.getTree().getColumns();
        TreeColumn treeColumn = treeColumns[0];
        TreeColumnWidthQuery treeColumnWidthQuery = new TreeColumnWidthQuery(treeColumn);
        Display.getDefault().syncExec((Runnable)((Object)treeColumnWidthQuery));
        int widgetWidth = (Integer)treeColumnWidthQuery.getResult();
        if (dTable.getHeaderColumnWidth() != widgetWidth && dTable.getHeaderColumnWidth() > 0) {
            treeColumn.setWidth(dTable.getHeaderColumnWidth());
        }
        LinkedHashSet<DColumn> handledDColumns = new LinkedHashSet<DColumn>();
        int i = 1;
        while (i < treeColumns.length) {
            treeColumn = treeColumns[i];
            DColumn dColumn = (DColumn)treeColumn.getData("org.eclipse.sirius.table.ui.dTableColumn");
            if (dColumn != null && dTable.getColumns().contains((Object)dColumn)) {
                handledDColumns.add(dColumn);
                treeColumnWidthQuery = new TreeColumnWidthQuery(treeColumn);
                Display.getDefault().syncExec((Runnable)((Object)treeColumnWidthQuery));
                widgetWidth = (Integer)treeColumnWidthQuery.getResult();
                if (dColumn.isVisible() && dColumn.getWidth() > 0 && dColumn.getWidth() != widgetWidth) {
                    treeColumn.setWidth(dColumn.getWidth());
                }
            } else {
                ((DTableViewerManager)treeViewerManager).removeOldColumn(dColumn);
            }
            ++i;
        }
        for (DColumn newColumn : Sets.difference((Set)Sets.newLinkedHashSet((Iterable)dTable.getColumns()), handledDColumns)) {
            int position = dTable.getColumns().indexOf((Object)newColumn) + 1;
            DTableEditorUtil.addNewColumn(treeViewerManager, position, newColumn);
        }
        dTableTreeViewer.setExpandedElements(TableHelper.getExpandedLines((DTable)dTable).toArray());
    }

    public static boolean isLastColumn(TreeColumn treeColumn) {
        ArrayList allTreeColumns = Lists.newArrayList((Object[])treeColumn.getParent().getColumns());
        return allTreeColumns.indexOf(treeColumn) == allTreeColumns.size() - 1;
    }
}

