/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ToggleRevealOnConnectContributionItem
extends ActionContributionItem {
    public ToggleRevealOnConnectContributionItem() {
        super((IAction)new ToggleAction());
    }

    public void fill(Menu parent, int index) {
        this.updateAction();
        super.fill(parent, index);
    }

    protected static IStructuredSelection getSelection() {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww == null) {
            return null;
        }
        ISelection selection = ww.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    private void updateAction() {
        boolean enabled = false;
        int on = 0;
        IStructuredSelection selection = ToggleRevealOnConnectContributionItem.getSelection();
        if (selection != null) {
            for (Object o : selection.toList()) {
                if (!(o instanceof IFSTreeNode)) {
                    enabled = false;
                    break;
                }
                IFSTreeNode node = (IFSTreeNode)o;
                if (node.isFileSystem()) {
                    enabled = false;
                    break;
                }
                on += node.isRevealOnConnect() ? 1 : -1;
                enabled = true;
            }
        }
        IAction action = this.getAction();
        action.setEnabled(enabled);
        action.setChecked(on > 0);
    }

    private static class ToggleAction
    extends Action {
        public ToggleAction() {
            super(Messages.ToggleRevealOnConnectContributionItem_text, 2);
        }

        public void run() {
            boolean value = this.isChecked();
            IStructuredSelection selection = ToggleRevealOnConnectContributionItem.getSelection();
            if (selection != null) {
                for (Object o : selection.toList()) {
                    if (!(o instanceof IFSTreeNode)) continue;
                    ((IFSTreeNode)o).setRevealOnConnect(value);
                }
            }
        }
    }
}

