/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class BuildCleanupListener
implements IResourceDeltaVisitor,
IResourceChangeListener {
    public static IResource getResourceFor(IProject container, IResource destination, IPath originating) {
        switch (destination.getType()) {
            case 1: {
                return container.getFile(originating);
            }
            case 2: {
                return container.getFolder(originating);
            }
            case 4: {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(originating.toString());
            }
        }
        return destination;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        boolean movedFrom = (delta.getFlags() & 0x1000) > 0;
        switch (delta.getKind()) {
            case 1: {
                if (!resource.exists()) break;
                if (EclipseSynchronizer.getInstance().wasPhantom(resource)) {
                    EclipseSynchronizer.getInstance().resourcesRecreated(new IResource[]{resource}, null);
                }
                if (resource.getType() != 2) break;
                if (resource.getName().equals("CVS")) {
                    this.handleOrphanedSubtree(resource.getParent());
                    break;
                }
                this.handleOrphanedSubtree((IContainer)resource);
                break;
            }
            case 4: {
                if (!movedFrom || resource.getType() != 2 || !resource.exists()) break;
                return !this.handleOrphanedSubtree((IContainer)resource);
            }
        }
        return true;
    }

    private boolean handleOrphanedSubtree(IContainer container) {
        try {
            if (CVSWorkspaceRoot.isOrphanedSubtree(container)) {
                ICVSFolder mFolder = CVSWorkspaceRoot.getCVSFolderFor(container);
                mFolder.unmanage(null);
                return true;
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta root = event.getDelta();
            IResourceDelta[] projectDeltas = root.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                final IResourceDelta delta = projectDeltas[i];
                IResource resource = delta.getResource();
                if (resource.getType() != 4 || resource.isAccessible()) {
                    RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId());
                    ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource.getProject());
                    if (provider != null) {
                        try {
                            if (!folder.isCVSFolder()) {
                                RepositoryProvider.unmap((IProject)resource.getProject());
                                provider = null;
                            }
                        }
                        catch (TeamException e) {
                            CVSProviderPlugin.log((CoreException)((Object)e));
                        }
                    }
                    if ((delta.getFlags() & 0x2000) > 0) {
                        IResource destination = BuildCleanupListener.getResourceFor(resource.getProject(), resource, delta.getMovedToPath());
                        provider = RepositoryProvider.getProvider((IProject)destination.getProject());
                    }
                    if (provider != null) {
                        folder.run(new ICVSRunnable(){

                            @Override
                            public void run(IProgressMonitor monitor) throws CVSException {
                                try {
                                    delta.accept((IResourceDeltaVisitor)BuildCleanupListener.this);
                                }
                                catch (CoreException e) {
                                    Util.logError(CVSMessages.ResourceDeltaVisitor_visitError, e);
                                }
                            }
                        }, Policy.monitorFor(null));
                    }
                }
                ++i;
            }
        }
        catch (CVSException e) {
            Util.logError(CVSMessages.ResourceDeltaVisitor_visitError, (Throwable)((Object)e));
        }
    }
}

