/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readwrite;

import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlStateValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readwrite.TmfXmlReadWriteModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;

public class TmfXmlReadWriteStateValue
extends TmfXmlStateValue {
    private static final String ILLEGAL_STATE_EXCEPTION_MESSAGE = "The state system hasn't been initialized yet";

    public TmfXmlReadWriteStateValue(TmfXmlReadWriteModelFactory modelFactory, Element node, IXmlStateSystemContainer container, List<ITmfXmlStateAttribute> attributes) {
        this(modelFactory, node, container, attributes, null);
    }

    public TmfXmlReadWriteStateValue(TmfXmlReadWriteModelFactory modelFactory, Element node, IXmlStateSystemContainer container, String eventField) {
        this(modelFactory, node, container, new ArrayList<ITmfXmlStateAttribute>(), eventField);
    }

    private TmfXmlReadWriteStateValue(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container, List<ITmfXmlStateAttribute> attributes, @Nullable String eventField) {
        super(modelFactory, node, container, attributes, eventField);
    }

    protected @Nullable ITmfStateSystemBuilder getStateSystem() {
        return (ITmfStateSystemBuilder)super.getStateSystem();
    }

    @Override
    protected TmfXmlStateValue.TmfXmlStateValueBase initializeStateValue(ITmfXmlModelFactory modelFactory, Element node) {
        ITmfStateValue.Type forcedType;
        TmfXmlStateValueTypeReadWrite stateValueType = null;
        String type = node.getAttribute("type");
        String value = this.getSsContainer().getAttributeValue(node.getAttribute("value"));
        String forcedTypeName = node.getAttribute("forcedType");
        ITmfStateValue.Type type2 = forcedType = forcedTypeName.isEmpty() ? ITmfStateValue.Type.NULL : TmfXmlUtils.getTmfStateValueByName(forcedTypeName);
        if (value == null && this.getStackType().equals((Object)TmfXmlStateValue.ValueTypeStack.NULL)) {
            throw new IllegalStateException();
        }
        List<@Nullable Element> children = XmlUtils.getChildElements(node);
        ArrayList<ITmfXmlStateAttribute> childAttributes = new ArrayList<ITmfXmlStateAttribute>();
        ArrayList<TmfXmlStateValue> childStateValues = new ArrayList<TmfXmlStateValue>();
        for (Element child : children) {
            if (child == null) continue;
            if (child.getNodeName().equals("stateValue")) {
                TmfXmlStateValue stateValue = (TmfXmlStateValue)modelFactory.createStateValue(child, this.getSsContainer(), new ArrayList<ITmfXmlStateAttribute>());
                childStateValues.add(stateValue);
                continue;
            }
            ITmfXmlStateAttribute queryAttribute = modelFactory.createStateAttribute(child, this.getSsContainer());
            childAttributes.add(queryAttribute);
        }
        switch (type) {
            case "int": {
                TmfStateValue stateValue = value != null && !value.isEmpty() ? TmfXmlUtils.newTmfStateValueFromObjectWithForcedType(Integer.parseInt(value), forcedType) : TmfStateValue.nullValue();
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue, childAttributes);
                break;
            }
            case "long": {
                TmfStateValue stateValue = value != null && !value.isEmpty() ? TmfXmlUtils.newTmfStateValueFromObjectWithForcedType(Long.parseLong(value), forcedType) : TmfStateValue.nullValue();
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue, childAttributes);
                break;
            }
            case "string": {
                TmfStateValue stateValue = value != null ? TmfXmlUtils.newTmfStateValueFromObjectWithForcedType(value, forcedType) : TmfStateValue.nullValue();
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue, childAttributes);
                break;
            }
            case "null": {
                TmfStateValue stateValue = TmfStateValue.nullValue();
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue, childAttributes);
                break;
            }
            case "eventField": {
                if (value == null) {
                    throw new IllegalStateException("Event field name cannot be null");
                }
                stateValueType = new TmfXmlStateValueEventField(value);
                break;
            }
            case "eventName": {
                stateValueType = new TmfXmlStateValueEventName();
                break;
            }
            case "delete": {
                stateValueType = new TmfXmlStateValueDelete();
                break;
            }
            case "query": {
                stateValueType = new TmfXmlStateValueQuery(childAttributes);
                break;
            }
            case "script": {
                if (value == null) {
                    throw new IllegalStateException(Messages.TmfXmlStateValue_ScriptNullException);
                }
                String scriptEngine = node.getAttribute("scriptEngine");
                stateValueType = new TmfXmlStateValueScript(scriptEngine, value, childStateValues, forcedType);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("TmfXmlStateValue constructor: unexpected element %s for stateValue type", type));
            }
        }
        return stateValueType;
    }

    private static @Nullable ITmfStateValue incrementByType(int quark, ITmfStateSystem ss, ITmfStateValue stateValue) {
        TmfStateValue value = null;
        switch (stateValue.getType()) {
            case LONG: {
                long incrementLong = stateValue.unboxLong();
                ITmfStateValue currentState = ss.queryOngoingState(quark);
                long currentValue = currentState.isNull() ? 0L : currentState.unboxLong();
                value = TmfStateValue.newValueLong((long)(incrementLong + currentValue));
                return value;
            }
            case INTEGER: {
                int increment = stateValue.unboxInt();
                ITmfStateValue currentState = ss.queryOngoingState(quark);
                int currentValue = currentState.isNull() ? 0 : currentState.unboxInt();
                value = TmfStateValue.newValueInt((int)(increment + currentValue));
                return value;
            }
        }
        return value;
    }

    private class TmfXmlStateValueDelete
    extends TmfXmlStateValueTypeReadWrite {
        private TmfXmlStateValueDelete() {
        }

        @Override
        public @NonNull ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
            return TmfStateValue.nullValue();
        }

        @Override
        protected void processValue(int quark, long timestamp, ITmfStateValue value) throws TimeRangeException, AttributeNotFoundException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (!(ss instanceof ITmfStateSystemBuilder)) {
                throw new IllegalStateException("incrementValue should never be called when not building the state system");
            }
            ITmfStateSystemBuilder builder = ss;
            builder.removeAttribute(timestamp, quark);
        }

        public String toString() {
            return "Delete";
        }
    }

    private class TmfXmlStateValueEventField
    extends TmfXmlStateValueTypeReadWrite {
        private final String fFieldName;

        public TmfXmlStateValueEventField(String field) {
            this.fFieldName = field;
        }

        @Override
        public ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
            if (event == null) {
                Activator.logWarning("XML State value: requested an event field, but event is null");
                return TmfStateValue.nullValue();
            }
            return TmfXmlReadWriteStateValue.this.getEventFieldValue(event, this.fFieldName);
        }

        @Override
        public void incrementValue(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            ITmfStateValue incrementValue;
            ITmfStateSystem ss = TmfXmlReadWriteStateValue.this.getSsContainer().getStateSystem();
            ITmfStateValue value = TmfXmlReadWriteStateValue.incrementByType(quark, ss, incrementValue = this.getValue(event, scenarioInfo));
            if (value != null) {
                this.processValue(quark, timestamp, value);
            } else {
                Activator.logWarning(String.format("TmfXmlStateValue: The event field increment %s is not a number type but a %s", this.fFieldName, incrementValue.getType()));
            }
        }

        public String toString() {
            return "Event Field=" + this.fFieldName;
        }
    }

    private class TmfXmlStateValueEventName
    extends TmfXmlStateValueTypeReadWrite {
        private TmfXmlStateValueEventName() {
        }

        @Override
        public @NonNull ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
            if (event == null) {
                Activator.logWarning("XML State value: request event name, but event is null");
                return TmfStateValue.nullValue();
            }
            return TmfStateValue.newValueString((String)event.getName());
        }

        public String toString() {
            return "Event name";
        }
    }

    private class TmfXmlStateValueQuery
    extends TmfXmlStateValueTypeReadWrite {
        private final List<ITmfXmlStateAttribute> fQueryValue;

        public TmfXmlStateValueQuery(List<ITmfXmlStateAttribute> childAttributes) {
            this.fQueryValue = childAttributes;
        }

        @Override
        public ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
            TmfStateValue value = TmfStateValue.nullValue();
            int quarkQuery = -1;
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            for (ITmfXmlStateAttribute attribute : this.fQueryValue) {
                quarkQuery = attribute.getAttributeQuark(event, quarkQuery, scenarioInfo);
                if (quarkQuery == -1) break;
            }
            if (quarkQuery != -1) {
                value = ss.queryOngoingState(quarkQuery);
            }
            return value;
        }

        @Override
        public void incrementValue(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            ITmfStateValue incrementValue = this.getValue(event, scenarioInfo);
            ITmfStateValue value = TmfXmlReadWriteStateValue.incrementByType(quark, (ITmfStateSystem)ss, incrementValue);
            if (value != null) {
                this.processValue(quark, timestamp, value);
            } else {
                Activator.logWarning("TmfXmlStateValue: The query result increment is not a number type");
            }
        }

        public String toString() {
            return "Query=" + this.fQueryValue;
        }
    }

    private class TmfXmlStateValueScript
    extends TmfXmlStateValueTypeReadWrite {
        public static final String DEFAULT_SCRIPT_ENGINE = "nashorn";
        private final List<TmfXmlStateValue> fChildStateValues;
        private final String fScriptEngine;
        private final String fScript;
        private final ITmfStateValue.Type fForcedType;

        public TmfXmlStateValueScript(String scriptEngine, String script, List<TmfXmlStateValue> childStateValues, ITmfStateValue.Type forcedType) {
            this.fScriptEngine = !scriptEngine.isEmpty() ? scriptEngine : DEFAULT_SCRIPT_ENGINE;
            this.fScript = script;
            this.fChildStateValues = childStateValues;
            this.fForcedType = forcedType;
        }

        @Override
        public ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
            Object result = null;
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName(this.fScriptEngine);
            for (TmfXmlStateValue stateValue : this.fChildStateValues) {
                String stateValueID = stateValue.getID();
                if (stateValueID != null) {
                    ITmfStateValue value = stateValue.getValue(event, scenarioInfo);
                    switch (value.getType()) {
                        case LONG: {
                            engine.put(stateValueID, value.unboxLong());
                            break;
                        }
                        case INTEGER: {
                            engine.put(stateValueID, value.unboxInt());
                            break;
                        }
                        case STRING: {
                            engine.put(stateValueID, value.unboxStr());
                            break;
                        }
                        case NULL: 
                        case DOUBLE: 
                        case CUSTOM: {
                            engine.put(stateValueID, null);
                        }
                    }
                    continue;
                }
                Activator.logWarning(Messages.TmfXmlStateValue_MissingScriptChildrenID);
            }
            try {
                result = engine.eval(this.fScript);
            }
            catch (ScriptException e) {
                Activator.logError("Script execution failed", e);
                return TmfStateValue.nullValue();
            }
            return TmfXmlUtils.newTmfStateValueFromObjectWithForcedType(result, this.fForcedType);
        }

        public String toString() {
            return "Script=" + this.fScript;
        }
    }

    private class TmfXmlStateValueTmf
    extends TmfXmlStateValueTypeReadWrite {
        private final ITmfStateValue fValue;
        private final List<ITmfXmlStateAttribute> fAttributesValue;

        public TmfXmlStateValueTmf(ITmfStateValue value, List<ITmfXmlStateAttribute> attributes) {
            this.fValue = value;
            this.fAttributesValue = attributes;
        }

        @Override
        public ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
            try {
                switch (TmfXmlReadWriteStateValue.this.getStackType()) {
                    case PEEK: {
                        return this.peek(event, scenarioInfo);
                    }
                }
                return this.fValue;
            }
            catch (AttributeNotFoundException | StateSystemDisposedException e) {
                Activator.logError("Query stack failed");
                return TmfStateValue.nullValue();
            }
        }

        private ITmfStateValue peek(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException, StateSystemDisposedException {
            int quarkQuery = -1;
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            if (event == null) {
                throw new IllegalStateException("The event should not be null at this point.");
            }
            for (ITmfXmlStateAttribute attribute : this.fAttributesValue) {
                quarkQuery = attribute.getAttributeQuark(event, quarkQuery, scenarioInfo);
                if (quarkQuery != -1) continue;
                return TmfStateValue.nullValue();
            }
            long ts = event.getTimestamp().toNanos();
            @Nullable ITmfStateInterval stackTopInterval = StateSystemUtils.querySingleStackTop((ITmfStateSystem)ss, (long)ts, (int)quarkQuery);
            ITmfStateValue value = stackTopInterval != null ? stackTopInterval.getStateValue() : null;
            return value != null ? value : TmfStateValue.nullValue();
        }

        @Override
        public void incrementValue(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            ITmfStateValue value = TmfXmlReadWriteStateValue.incrementByType(quark, (ITmfStateSystem)ss, this.fValue);
            if (value != null) {
                this.processValue(quark, timestamp, value);
            } else {
                Activator.logWarning("TmfXmlStateValue: The increment value is not a number type");
            }
        }

        public String toString() {
            return "Value=" + this.fValue;
        }
    }

    protected abstract class TmfXmlStateValueTypeReadWrite
    extends TmfXmlStateValue.TmfXmlStateValueBase {
        protected TmfXmlStateValueTypeReadWrite() {
            super(TmfXmlReadWriteStateValue.this);
        }

        @Override
        public final void handleEvent(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            if (TmfXmlReadWriteStateValue.this.isIncrement()) {
                this.incrementValue(event, quark, timestamp, scenarioInfo);
            } else {
                ITmfStateValue value = this.getValue(event, scenarioInfo);
                this.processValue(quark, timestamp, value);
            }
        }

        @Override
        protected void processValue(int quark, long timestamp, ITmfStateValue value) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            switch (TmfXmlReadWriteStateValue.this.getStackType()) {
                case POP: {
                    ss.popAttribute(timestamp, quark);
                    break;
                }
                case PUSH: {
                    ss.pushAttribute(timestamp, value.unboxValue(), quark);
                    break;
                }
                case POP_ALL: {
                    ITmfStateValue stackState = ss.queryOngoingState(quark);
                    if (stackState.getType() != ITmfStateValue.Type.INTEGER) break;
                    int nbElements = stackState.unboxInt();
                    int i = 0;
                    while (i < nbElements) {
                        ss.popAttribute(timestamp, quark);
                        ++i;
                    }
                    break;
                }
                default: {
                    if (TmfXmlReadWriteStateValue.this.isUpdate()) {
                        ss.updateOngoingState(value, quark);
                        break;
                    }
                    ss.modifyAttribute(timestamp, value.unboxValue(), quark);
                }
            }
        }

        @Override
        protected void incrementValue(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ss, (long)timestamp, (int)quark, (int)1);
        }
    }
}

