/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.swtchart;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartData;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartModel;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartSeries;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.INumericalResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.IStringResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.signal.ChartSelectionUpdateSignal;
import org.eclipse.tracecompass.internal.tmf.chart.core.aggregator.IConsumerAggregator;
import org.eclipse.tracecompass.internal.tmf.chart.core.consumer.IDataConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.core.consumer.NumericalConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.aggregator.NumericalConsumerAggregator;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.BarStringConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.XYChartConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.XYSeriesConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRangeMap;
import org.eclipse.tracecompass.internal.tmf.chart.ui.swtchart.SwtChartPoint;
import org.eclipse.tracecompass.internal.tmf.chart.ui.swtchart.SwtXYChartViewer;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.swtchart.IAxis;
import org.swtchart.IAxisTick;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;

public final class SwtBarChart
extends SwtXYChartViewer {
    private static final int BAR_PADDING = 20;
    private static final double LENGTH_LIMIT = 0.4;
    private ChartRangeMap fYRanges = new ChartRangeMap();
    private String @Nullable [] fCategories;

    public SwtBarChart(Composite parent, ChartData data, ChartModel model) {
        super(parent, data, model);
        this.getChart().getPlotArea().addMouseListener((MouseListener)new MouseDownListener());
        this.getChart().getPlotArea().addPaintListener((PaintListener)new BarPainterListener());
        this.populate();
    }

    @Override
    public void validateChartData() {
        super.validateChartData();
        if (this.getXDescriptorsInfo().areNumerical()) {
            throw new IllegalArgumentException("Bar chart X axis cannot be numerical.");
        }
        if (!this.getYDescriptorsInfo().areNumerical()) {
            throw new IllegalArgumentException("Bar chart Y axis must be numerical.");
        }
        if (this.getXDescriptors().stream().distinct().count() > 1L) {
            throw new IllegalArgumentException("Bar chart can only have one X axis.");
        }
    }

    @Override
    protected IDataConsumer getXConsumer(@NonNull ChartSeries series) {
        IStringResolver xResolver = (IStringResolver)IStringResolver.class.cast(series.getX().getResolver());
        return new BarStringConsumer((IStringResolver<Object>)xResolver);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected IDataConsumer getYConsumer(@NonNull ChartSeries series) {
        INumericalResolver yResolver = (INumericalResolver)INumericalResolver.class.cast(series.getY().getResolver());
        @Nullable SwtXYChartViewer.LogarithmicPredicate yPredicate = this.getModel().isYLogscale() ? new SwtXYChartViewer.LogarithmicPredicate(yResolver) : o -> true;
        return new NumericalConsumer(yResolver, (Predicate)yPredicate);
    }

    @Override
    protected @Nullable IConsumerAggregator getXAggregator() {
        return null;
    }

    @Override
    protected @Nullable IConsumerAggregator getYAggregator() {
        return new NumericalConsumerAggregator();
    }

    @Override
    protected ISeries createSwtSeries(ChartSeries chartSeries, ISeriesSet swtSeriesSet, @NonNull Color color) {
        String title = chartSeries.getY().getLabel();
        IBarSeries swtSeries = (IBarSeries)swtSeriesSet.createSeries(ISeries.SeriesType.BAR, title);
        swtSeries.setBarPadding(20);
        swtSeries.setBarColor(color);
        return swtSeries;
    }

    @Override
    protected void configureSeries(Map<@NonNull ISeries, Object[]> mapper) {
        XYChartConsumer chartConsumer = this.getChartConsumer();
        NumericalConsumerAggregator aggregator = (NumericalConsumerAggregator)NonNullUtils.checkNotNull((Object)chartConsumer.getYAggregator());
        this.fYRanges = SwtBarChart.clampInputDataRange((ChartRangeMap)NonNullUtils.checkNotNull((Object)aggregator.getChartRanges()));
        for (XYSeriesConsumer seriesConsumer : chartConsumer.getSeries()) {
            BarStringConsumer xconsumer = (BarStringConsumer)seriesConsumer.getXConsumer();
            NumericalConsumer yConsumer = (NumericalConsumer)seriesConsumer.getYConsumer();
            Object[] object = seriesConsumer.getConsumedElements().toArray();
            Collection<@Nullable String> list = xconsumer.getList();
            String @Nullable [] categories = list.toArray(new String[list.size()]);
            int i = 0;
            while (i < list.size()) {
                if (categories[i] == null) {
                    categories[i] = "?";
                }
                ++i;
            }
            this.fCategories = categories;
            List data = yConsumer.getData();
            double[] yData = new double[data.size()];
            int i2 = 0;
            while (i2 < yData.length) {
                Number number = (Number)NonNullUtils.checkNotNull((Object)((Number)data.get(i2)));
                yData[i2] = this.fYRanges.getInternalValue(number).doubleValue();
                ++i2;
            }
            ISeries series = (ISeries)NonNullUtils.checkNotNull((Object)this.getSeriesMap().get(seriesConsumer.getSeries()));
            series.setYSeries(yData);
            mapper.put(series, (Object[])NonNullUtils.checkNotNull((Object)object));
        }
    }

    @Override
    protected void configureAxes() {
        Stream.of(this.getChart().getAxisSet().getXAxes()).forEach(a -> {
            a.enableCategory(true);
            a.setCategorySeries(this.fCategories);
        });
        Stream.of(this.getChart().getAxisSet().getYAxes()).forEach(a -> {
            IAxisTick tick = a.getTick();
            tick.setFormat(SwtBarChart.getContinuousAxisFormatter(this.fYRanges, this.getYDescriptorsInfo()));
        });
    }

    @Override
    protected void setSelection(@NonNull Set<@NonNull Object> set) {
        super.setSelection(set);
        Iterator colorsIt = Iterators.cycle((Iterable)COLORS);
        Iterator lightColorsIt = Iterators.cycle((Iterable)COLORS_LIGHT);
        ISeries[] iSeriesArray = this.getChart().getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            Color lightColor = (Color)NonNullUtils.checkNotNull((Object)((Color)lightColorsIt.next()));
            Color color = (Color)NonNullUtils.checkNotNull((Object)((Color)colorsIt.next()));
            if (set.isEmpty()) {
                ((IBarSeries)series).setBarColor(color);
            } else {
                ((IBarSeries)series).setBarColor(lightColor);
            }
            ++n2;
        }
    }

    @Override
    protected void refreshDisplayLabels() {
        String @Nullable [] categories = this.fCategories;
        if (categories == null || categories.length == 0) {
            return;
        }
        IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
        if (!xAxis.getTick().isVisible() || !xAxis.isCategoryEnabled()) {
            return;
        }
        Rectangle rect = this.getChart().getClientArea();
        int lengthLimit = (int)((double)rect.height * 0.4);
        GC gc = new GC((Drawable)this.getParent());
        gc.setFont(xAxis.getTick().getFont());
        String longestString = Arrays.stream(categories).max(Comparator.comparingInt(String::length)).orElse(categories[0]);
        Point pixels = gc.stringExtent(longestString);
        int cutLen = 5;
        String[] displayCategories = new String[categories.length];
        if (pixels.x > lengthLimit) {
            int i = 0;
            while (i < categories.length) {
                displayCategories[i] = categories[i].length() > cutLen ? String.valueOf(categories[i].substring(0, cutLen)) + '\u2026' : categories[i];
                ++i;
            }
        } else {
            displayCategories = Arrays.copyOf(categories, categories.length);
        }
        xAxis.setCategorySeries(displayCategories);
        gc.dispose();
    }

    private final class BarPainterListener
    implements PaintListener {
        private BarPainterListener() {
        }

        public void paintControl(@Nullable PaintEvent event) {
            if (event == null) {
                return;
            }
            if (SwtBarChart.this.getSelection().getPoints().size() == 0) {
                return;
            }
            Iterator colors = Iterators.cycle((Iterable)COLORS);
            Iterator lights = Iterators.cycle((Iterable)COLORS_LIGHT);
            GC gc = event.gc;
            ISeries[] iSeriesArray = SwtBarChart.this.getChart().getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries swtSeries = iSeriesArray[n2];
                IBarSeries series = (IBarSeries)swtSeries;
                Color color = (Color)NonNullUtils.checkNotNull((Object)((Color)colors.next()));
                Color light = (Color)NonNullUtils.checkNotNull((Object)((Color)lights.next()));
                int i = 0;
                while (i < series.getBounds().length) {
                    gc.setBackground(light);
                    for (SwtChartPoint point : SwtBarChart.this.getSelection().getPoints()) {
                        if (point.getSeries() != series || point.getIndex() != i) continue;
                        gc.setBackground(color);
                        break;
                    }
                    gc.fillRectangle(series.getBounds()[i]);
                    ++i;
                }
                ++n2;
            }
        }
    }

    private final class MouseDownListener
    extends MouseAdapter {
        private MouseDownListener() {
        }

        public void mouseDown(@Nullable MouseEvent event) {
            if (event == null || event.button != 1) {
                return;
            }
            int xClick = event.x;
            int yClick = event.y;
            boolean ctrl = (event.stateMask & 0x40000) != 0;
            boolean found = false;
            ISeries[] iSeriesArray = SwtBarChart.this.getChart().getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries swtSeries = iSeriesArray[n2];
                IBarSeries series = (IBarSeries)swtSeries;
                Rectangle[] rectangles = series.getBounds();
                int i = 0;
                while (i < rectangles.length) {
                    if (rectangles[i].contains(xClick, yClick)) {
                        SwtBarChart.this.getSelection().touch(new SwtChartPoint((ISeries)series, i), ctrl);
                        found = true;
                    }
                    ++i;
                }
                ++n2;
            }
            if (!found) {
                SwtBarChart.this.getSelection().clear();
            }
            SwtBarChart.this.refresh();
            HashSet<Object> set = new HashSet<Object>();
            for (SwtChartPoint point : SwtBarChart.this.getSelection().getPoints()) {
                Object[] objects = (Object[])NonNullUtils.checkNotNull((Object)SwtBarChart.this.getObjectMap().get(point.getSeries()));
                Object obj = objects[point.getIndex()];
                if (obj == null) continue;
                set.add(obj);
            }
            SwtBarChart.this.setSelection(set);
            ChartSelectionUpdateSignal signal = new ChartSelectionUpdateSignal((Object)SwtBarChart.this, SwtBarChart.this.getData().getDataProvider(), set);
            TmfSignalManager.dispatchSignal((TmfSignal)signal);
        }
    }
}

