/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.CustomParserUtils;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards.CustomTxtParserInputWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards.CustomTxtParserOutputWizardPage;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CustomTxtParserWizard
extends Wizard
implements INewWizard {
    CustomTxtParserInputWizardPage inputPage;
    CustomTxtParserOutputWizardPage outputPage;
    private ISelection selection;
    CustomTxtTraceDefinition definition;
    String initialCategoryName;
    String initialDefinitionName;

    public CustomTxtParserWizard() {
        this(null);
    }

    public CustomTxtParserWizard(CustomTxtTraceDefinition definition) {
        this.definition = definition;
        if (definition != null) {
            this.initialCategoryName = definition.categoryName;
            this.initialDefinitionName = definition.definitionName;
        }
        this.setWindowTitle(Messages.CustomTxtParserInputWizardPage_windowTitle);
    }

    public boolean performFinish() {
        CustomTxtTraceDefinition def = this.outputPage.getDefinition();
        if (this.definition != null) {
            if (!this.initialCategoryName.equals(def.categoryName) || !this.initialDefinitionName.equals(def.definitionName)) {
                CustomTxtTraceDefinition.delete((String)this.initialCategoryName, (String)this.initialDefinitionName);
            }
            CustomParserUtils.cleanup(CustomTxtTrace.buildTraceTypeId((String)this.initialCategoryName, (String)this.initialDefinitionName));
        }
        def.save();
        CustomParserUtils.cleanup(CustomTxtTrace.buildTraceTypeId((String)def.categoryName, (String)def.definitionName));
        return true;
    }

    public void addPages() {
        this.inputPage = new CustomTxtParserInputWizardPage(this.selection, this.definition);
        this.addPage((IWizardPage)this.inputPage);
        this.outputPage = new CustomTxtParserOutputWizardPage(this);
        this.addPage((IWizardPage)this.outputPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        this.selection = sel;
    }
}

