/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.specifications;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.ParameterReference;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.transformation.views.traceability.generic.AbstractQuerySpecificationDescriptor;

public class EdgeQuerySpecificationDescriptor
extends AbstractQuerySpecificationDescriptor {
    public static final String ANNOTATION_ID = "Edge";
    private static final String SOURCE_PARAMETER_NAME = "source";
    private static final String TARGET_PARAMETER_NAME = "target";
    private static final String LABEL_PARAMETER_NAME = "label";
    private final String source;
    private final String target;
    private final String label;
    private final PAnnotation formatAnnotation;

    public EdgeQuerySpecificationDescriptor(IQuerySpecification<?> specification, PAnnotation annotation) {
        super(specification, EdgeQuerySpecificationDescriptor.getTraceSource(specification, annotation), Collections.emptyMap());
        String parameterTargetValue;
        String parameterSourceValue;
        ParameterReference parameterSource = (ParameterReference)annotation.getFirstValue(SOURCE_PARAMETER_NAME, ParameterReference.class).orElseThrow(() -> new QueryProcessingException("Invalid source value", (Object)specification));
        this.source = parameterSourceValue = parameterSource.getName();
        ParameterReference parameterTarget = (ParameterReference)annotation.getFirstValue(TARGET_PARAMETER_NAME, ParameterReference.class).orElseThrow(() -> new QueryProcessingException("Invalid target value", (Object)specification));
        this.target = parameterTargetValue = parameterTarget.getName();
        this.label = annotation.getFirstValue(LABEL_PARAMETER_NAME, String.class).orElse("");
        this.formatAnnotation = specification.getFirstAnnotationByName("Format").orElse(null);
    }

    private static Multimap<PParameter, PParameter> getTraceSource(IQuerySpecification<?> specification, PAnnotation annotation) {
        ArrayListMultimap traces = ArrayListMultimap.create();
        ParameterReference parameterSource = (ParameterReference)annotation.getFirstValue(SOURCE_PARAMETER_NAME, ParameterReference.class).orElseThrow(() -> new QueryProcessingException("Invalid source value", (Object)specification));
        ParameterReference parameterTarget = (ParameterReference)annotation.getFirstValue(TARGET_PARAMETER_NAME, ParameterReference.class).orElseThrow(() -> new QueryProcessingException("Invalid target value", (Object)specification));
        EdgeQuerySpecificationDescriptor.insertToTraces(specification, (Multimap<PParameter, PParameter>)traces, parameterSource.getName());
        EdgeQuerySpecificationDescriptor.insertToTraces(specification, (Multimap<PParameter, PParameter>)traces, parameterTarget.getName());
        return traces;
    }

    private static void insertToTraces(IQuerySpecification<?> specification, Multimap<PParameter, PParameter> traces, String parameter) {
        String targetName = "trace<" + parameter + ">";
        PParameter var_target = new PParameter(targetName, String.valueOf(NotationPackage.eINSTANCE.getNsURI()) + "||" + NotationPackage.eINSTANCE.getItem().getName());
        int positionOfParameter = specification.getPositionOfParameter(parameter);
        PParameter var_source = (PParameter)specification.getParameters().get(positionOfParameter);
        traces.put((Object)var_target, (Object)var_source);
    }

    public boolean isFormatted() {
        return this.formatAnnotation != null;
    }

    public PAnnotation getFormatAnnotation() {
        return this.formatAnnotation;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String getLabel() {
        return this.label;
    }
}

