/**
 * Copyright (c) 2010-2016, Gabor Bergmann, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Gabor Bergmann - initial API and implementation
 */
package org.eclipse.viatra.query.testing.core;

import com.google.common.base.Function;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IQueryGroup;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.testing.core.QueryPerformanceTest;

/**
 * A variant of {@link QueryPerformanceTest}, where an ensemble of queries is measured together, instead of as individual queries.
 * 
 * @author Gabor Bergmann
 */
@SuppressWarnings("all")
public abstract class QueryGroupPerformanceTest extends QueryPerformanceTest {
  @Override
  public void measureEntireGroup() {
    final IQueryGroup group = this.getQueryGroup();
    final long usedHeapBefore = this.wipeAndMeasure();
    final Function<AdvancedViatraQueryEngine, ViatraQueryMatcher<?>> _function = (AdvancedViatraQueryEngine it) -> {
      group.prepare(it);
      return null;
    };
    this.performMeasurements("*group*", (-1), usedHeapBefore, _function);
  }
}
