/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.XtextIndexBasedRegistryUpdater;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class LoadVqlPatternHandler extends AbstractHandler {
  @Inject
  Injector injector;
  
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    final IEditorPart editorPart = HandlerUtil.getActiveEditorChecked(event);
    final IViewPart resultView = HandlerUtil.getActiveSite(event).getPage().findView(QueryResultView.ID);
    if ((resultView instanceof QueryResultView)) {
      final QueryResultView queryResultView = ((QueryResultView) resultView);
      final boolean active = queryResultView.hasActiveEngine();
      if ((active && (editorPart instanceof XtextEditor))) {
        final XtextEditor xtextEditor = ((XtextEditor) editorPart);
        final IResource resource = xtextEditor.getResource();
        String _name = resource.getProject().getName();
        final String sourceId = (XtextIndexBasedRegistryUpdater.DYNAMIC_CONNECTOR_ID_PREFIX + _name);
        final IUnitOfWork<HashSet<String>, XtextResource> _function = (XtextResource state) -> {
          final HashSet<String> fqns = CollectionLiterals.<String>newHashSet();
          final TreeIterator<EObject> iterator = state.getAllContents();
          final Procedure1<EObject> _function_1 = (EObject pattern) -> {
            if ((pattern instanceof Pattern)) {
              fqns.add(PatternLanguageHelper.getFullyQualifiedName(((Pattern)pattern)));
              iterator.prune();
            }
          };
          IteratorExtensions.<EObject>forEach(iterator, _function_1);
          return fqns;
        };
        final Set<String> patternFQNs = xtextEditor.getDocument().<HashSet<String>>readOnly(_function);
        queryResultView.loadQueriesIntoActiveEngineInBackground(patternFQNs, sourceId);
      } else {
        MessageDialog.openError(queryResultView.getSite().getShell(), "Query loading failed", 
          "Please load a model into the Query Results view before loading queries!");
      }
    }
    return null;
  }
}
