/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.RuleBase;
import org.eclipse.viatra.transformation.evm.api.RuleInstance;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventRealm;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.api.resolver.ScopedConflictSet;

public class RuleEngine {
    private static final String FILTER_MUST_BE_SPECIFIED = "Filter must be specified";
    private static final String RULE_SPECIFICATION_MUST_BE_SPECIFIED = "Rule specification must be specified!";
    private RuleBase ruleBase;

    protected RuleEngine(RuleBase ruleBase) {
        this.ruleBase = Objects.requireNonNull(ruleBase, "Cannot create rule engine with null ruleBase!");
    }

    public static RuleEngine create(RuleBase ruleBase) {
        return new RuleEngine(ruleBase);
    }

    public void setConflictResolver(ConflictResolver conflictResolver) {
        Objects.requireNonNull(conflictResolver, "Conflict resolver cannot be null!");
        this.ruleBase.getAgenda().setConflictResolver(conflictResolver);
    }

    public <EventAtom> ScopedConflictSet createScopedConflictSet(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> eventFilter) {
        HashMap specifications = new HashMap();
        specifications.put(specification, Collections.singleton(eventFilter));
        return this.createScopedConflictSet(this.ruleBase.getAgenda().getConflictSet().getConflictResolver(), specifications);
    }

    public ScopedConflictSet createScopedConflictSet(Map<RuleSpecification<?>, Set<EventFilter<?>>> specifications) {
        return this.createScopedConflictSet(this.ruleBase.getAgenda().getConflictSet().getConflictResolver(), specifications);
    }

    public ScopedConflictSet createScopedConflictSet(ConflictResolver conflictResolver, Map<RuleSpecification<?>, Set<EventFilter<?>>> specifications) {
        Objects.requireNonNull(conflictResolver, "Conflict resolver cannot be null!");
        Objects.requireNonNull(specifications, "Specification set cannot be null!");
        ScopedConflictSet scopedConflictSet = this.ruleBase.createScopedConflictSet(conflictResolver, specifications);
        return scopedConflictSet;
    }

    public <EventAtom> boolean addRule(RuleSpecification<EventAtom> specification) {
        return this.addRule(specification, specification.createEmptyFilter());
    }

    public <EventAtom> boolean addRule(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Objects.requireNonNull(filter, FILTER_MUST_BE_SPECIFIED);
        Objects.requireNonNull(specification, RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        RuleInstance<? super EventAtom> instance = this.ruleBase.getInstance(specification, filter);
        boolean added = false;
        if (instance == null) {
            this.ruleBase.instantiateRule(specification, filter);
            added = true;
        }
        return added;
    }

    public <EventAtom> boolean containsRule(RuleSpecification<EventAtom> specification) {
        return this.containsRule(specification, specification.createEmptyFilter());
    }

    public <EventAtom> boolean containsRule(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Map<RuleSpecification<?>, Set<EventFilter<?>>> ruleSpecificationMultimap = this.ruleBase.getRuleSpecificationMultimap();
        return ruleSpecificationMultimap.containsKey(specification) && ruleSpecificationMultimap.get(specification).contains(filter);
    }

    public Map<ActivationState, Set<Activation<?>>> getActivations() {
        return Collections.unmodifiableMap(this.ruleBase.getAgenda().getActivations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new HashSet((Collection)entry.getValue()))));
    }

    public Activation<?> getNextActivation() {
        return this.ruleBase.getAgenda().getConflictSet().getNextActivation();
    }

    public Set<Activation<?>> getConflictingActivations() {
        return Collections.unmodifiableSet(new HashSet(this.ruleBase.getAgenda().getConflictSet().getConflictingActivations()));
    }

    public Set<Activation<?>> getActivations(ActivationState state) {
        Objects.requireNonNull(state, "Activation state must be specified!");
        return Collections.unmodifiableSet(new HashSet(this.ruleBase.getAgenda().getActivations(state)));
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification) {
        return this.getActivations(specification, specification.createEmptyFilter());
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Objects.requireNonNull(specification, RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        Objects.requireNonNull(filter, FILTER_MUST_BE_SPECIFIED);
        return Collections.unmodifiableSet(new HashSet<Activation<? super EventAtom>>(this.ruleBase.getInstance(specification, filter).getAllActivations()));
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification, ActivationState state) {
        return this.getActivations(specification, specification.createEmptyFilter(), state);
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter, ActivationState state) {
        Objects.requireNonNull(specification, RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        Objects.requireNonNull(state, "Activation state must be specified!");
        Objects.requireNonNull(filter, FILTER_MUST_BE_SPECIFIED);
        return Collections.unmodifiableSet(new HashSet<Activation<? super EventAtom>>(this.ruleBase.getInstance(specification, filter).getActivations(state)));
    }

    public Map<RuleSpecification<?>, Set<EventFilter<?>>> getRuleSpecificationMultimap() {
        return Collections.unmodifiableMap(this.ruleBase.getRuleSpecificationMultimap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new HashSet((Collection)entry.getValue()))));
    }

    public <EventAtom> boolean removeRule(RuleSpecification<EventAtom> specification) {
        Objects.requireNonNull(specification, RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        return this.ruleBase.removeRule(specification, specification.createEmptyFilter());
    }

    public <EventAtom> boolean removeRule(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Objects.requireNonNull(specification, RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        Objects.requireNonNull(filter, FILTER_MUST_BE_SPECIFIED);
        return this.ruleBase.removeRule(specification, filter);
    }

    protected RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public EventRealm getEventRealm() {
        return this.ruleBase.getEventRealm();
    }

    public Logger getLogger() {
        return this.ruleBase.getLogger();
    }

    public void dispose() {
        this.ruleBase.dispose();
    }
}

