/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api.event.adapter;

import java.util.Map;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.RuleInstance;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.Event;

public abstract class EventProcessorAdapter<EventAtom> {
    private final RuleInstance<EventAtom> instance;

    protected EventProcessorAdapter(RuleInstance<EventAtom> instance) {
        this.instance = instance;
    }

    public void processEvent(Event<EventAtom> event) {
        Objects.requireNonNull(event, "Cannot process null event!");
        Map<ActivationState, Activation<EventAtom>> activationMap = this.getInstance().getActivations(event.getEventAtom());
        if (activationMap.size() > 0) {
            Preconditions.checkArgument((activationMap.size() == 1 ? 1 : 0) != 0, (String)"%s activations in the same rule for the same match", (Object[])new Object[]{activationMap.size() == 0 ? "No" : "Multiple"});
            Activation<EventAtom> act = activationMap.values().iterator().next();
            this.activationExists(event, act);
        } else {
            this.activationMissing(event);
        }
    }

    protected abstract void activationExists(Event<EventAtom> var1, Activation<EventAtom> var2);

    protected abstract void activationMissing(Event<EventAtom> var1);

    protected RuleInstance<EventAtom> getInstance() {
        return this.instance;
    }
}

