/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.efs;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.chromium.debug.core.efs.ChromiumScriptFileSystem;
import org.eclipse.wst.jsdt.chromium.debug.core.efs.ChromiumScriptStorage;

public class ChromiumScriptFileStore
extends FileStore {
    private static final ChromiumScriptStorage STORAGE = ChromiumScriptStorage.getInstance();
    private final ChromiumScriptFileSystem fileSystem;
    private final IPath path;

    public ChromiumScriptFileStore(ChromiumScriptFileSystem fileSystem, IPath path) {
        this.fileSystem = fileSystem;
        this.path = path;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return STORAGE.childNames(this.path);
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return STORAGE.fetchInfo(this.path, options);
    }

    public IFileStore getChild(String name) {
        return this.fileSystem.getStore(this.path.append(name));
    }

    public String getName() {
        if (this.path.isEmpty()) {
            return "ROOT";
        }
        return this.path.lastSegment();
    }

    public IFileStore getParent() {
        if (this.path.segmentCount() == 0) {
            return null;
        }
        return new ChromiumScriptFileStore(this.fileSystem, this.path.removeLastSegments(1));
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return STORAGE.openInputStream(this.path, options);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        return STORAGE.openOutputStream(this.path, options);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        STORAGE.mkdir(this.path, options);
        return this;
    }

    public URI toURI() {
        return ChromiumScriptFileSystem.getFileStoreUri(this.path);
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        STORAGE.delete(this.path, options);
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        STORAGE.putInfo(this.path, info, options);
    }
}

