/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.CloseableMap;

public class BaseCommandProcessor<SEQ_KEY, OUTGOING, INCOMING, INCOMING_WITH_SEQ> {
    private static final Logger LOGGER = Logger.getLogger(BaseCommandProcessor.class.getName());
    private final CloseableMap<SEQ_KEY, CallbackEntry<INCOMING_WITH_SEQ>> callbackMap = CloseableMap.newLinkedMap();
    private final Handler<SEQ_KEY, OUTGOING, INCOMING, INCOMING_WITH_SEQ> handler;
    private final CallbackCaller<Callback<?>> failureCaller = new CallbackCaller<Callback<?>>(){

        @Override
        void call(Callback<?> handlerCallback) {
            handlerCallback.failure("Connection closed");
        }
    };
    private final Object vmStatusReportMonitor = new Object();
    private static final RelayOk WE_SENT_IT_RELAY_OK = new RelayOk(){};

    public BaseCommandProcessor(Handler<SEQ_KEY, OUTGOING, INCOMING, INCOMING_WITH_SEQ> handler) {
        this.handler = handler;
    }

    public RelayOk send(OUTGOING message, boolean isImmediate, Callback<? super INCOMING_WITH_SEQ> callback, SyncCallback syncCallback) {
        boolean callbackAdded;
        SEQ_KEY seq = this.handler.getUpdatedSeq(message);
        if (callback != null || syncCallback != null) {
            String commandName = this.handler.getCommandName(message);
            try {
                this.callbackMap.put(seq, new CallbackEntry<INCOMING_WITH_SEQ>(callback, syncCallback, commandName));
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Connection is closed", e);
            }
            callbackAdded = true;
            this.reportVmStatus();
        } else {
            callbackAdded = false;
        }
        try {
            this.handler.send(message, isImmediate);
        }
        catch (RuntimeException e) {
            if (callbackAdded) {
                this.callbackMap.remove(seq);
            }
            throw e;
        }
        return WE_SENT_IT_RELAY_OK;
    }

    public void processIncoming(INCOMING incomingParsed) {
        final INCOMING_WITH_SEQ commandResponse = this.handler.parseWithSeq(incomingParsed);
        if (commandResponse != null) {
            SEQ_KEY key = this.handler.getSeq(commandResponse);
            CallbackEntry<INCOMING_WITH_SEQ> callbackEntry = this.callbackMap.removeIfContains(key);
            if (callbackEntry != null) {
                LOGGER.log(Level.FINE, "Request-response roundtrip: {0}ms", BaseCommandProcessor.getCurrentMillis() - callbackEntry.commitMillis);
                this.reportVmStatus();
                CallbackCaller caller = new CallbackCaller<Callback<? super INCOMING_WITH_SEQ>>(){

                    @Override
                    void call(Callback<? super INCOMING_WITH_SEQ> handlerCallback) {
                        handlerCallback.messageReceived(commandResponse);
                    }
                };
                try {
                    this.callThemBack(callbackEntry, caller, key);
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.SEVERE, "Failed to dispatch response to callback", e);
                }
            }
        } else {
            this.handler.acceptNonSeq(incomingParsed);
        }
    }

    public void processEos() {
        Collection<CallbackEntry<INCOMING_WITH_SEQ>> entries = this.callbackMap.close().values();
        for (CallbackEntry<INCOMING_WITH_SEQ> entry : entries) {
            try {
                this.callThemBack(entry, this.failureCaller, null);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Failed to dispatch response to callback", e);
            }
        }
    }

    private void callThemBack(CallbackEntry<INCOMING_WITH_SEQ> callbackEntry, CallbackCaller<? super Callback<? super INCOMING_WITH_SEQ>> callbackCaller, SEQ_KEY requestSeq) {
        RuntimeException callbackException = null;
        try {
            try {
                if (callbackEntry.callback != null) {
                    LOGGER.log(Level.FINE, "Notified debugger command callback, request_seq={0}", requestSeq);
                    callbackCaller.call(callbackEntry.callback);
                }
            }
            catch (RuntimeException e) {
                callbackException = e;
                throw e;
            }
        }
        finally {
            if (callbackEntry.syncCallback != null) {
                callbackEntry.syncCallback.callbackDone(callbackException);
            }
        }
    }

    private static long getCurrentMillis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportVmStatus() {
        Object object = this.vmStatusReportMonitor;
        synchronized (object) {
            int size = this.callbackMap.size();
            CallbackEntry<INCOMING_WITH_SEQ> firstEntry = this.callbackMap.peekFirst();
            if (firstEntry == null) {
                this.handler.reportVmStatus(null, 0);
            } else {
                this.handler.reportVmStatus(firstEntry.requestName, size - 1);
            }
        }
    }

    public static interface Callback<INCOMING_WITH_SEQ> {
        public void messageReceived(INCOMING_WITH_SEQ var1);

        public void failure(String var1);
    }

    private static abstract class CallbackCaller<CALLBACK> {
        private CallbackCaller() {
        }

        abstract void call(CALLBACK var1);
    }

    private static class CallbackEntry<INCOMING_WITH_SEQ> {
        final Callback<? super INCOMING_WITH_SEQ> callback;
        final SyncCallback syncCallback;
        final long commitMillis;
        final String requestName;

        CallbackEntry(Callback<? super INCOMING_WITH_SEQ> callback, SyncCallback syncCallback, String requestName) {
            this.callback = callback;
            this.commitMillis = BaseCommandProcessor.getCurrentMillis();
            this.syncCallback = syncCallback;
            this.requestName = requestName;
        }
    }

    public static interface Handler<SEQ_KEY, OUTGOING, INCOMING, INCOMING_WITH_SEQ> {
        public SEQ_KEY getUpdatedSeq(OUTGOING var1);

        public String getCommandName(OUTGOING var1);

        public void send(OUTGOING var1, boolean var2);

        public INCOMING_WITH_SEQ parseWithSeq(INCOMING var1);

        public SEQ_KEY getSeq(INCOMING_WITH_SEQ var1);

        public void acceptNonSeq(INCOMING var1);

        public void reportVmStatus(String var1, int var2);
    }
}

