/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class XMLContentType {
    private static final String XMLSOURCE_CONTENTTYPE = "org.eclipse.wst.xml.core.xmlsource";
    private static final String PLATFORM_XMLSOURCE_CONTENTTYPE = "org.eclipse.core.runtime.xml";
    private IContentTypeManager contentTypeManager = Platform.getContentTypeManager();

    public String[] getFileExtensions() {
        IContentType[] contentTypes = this.getAllXMLContentTypes();
        ArrayList<String> xmlFileExtensions = new ArrayList<String>();
        if (contentTypes.length > 0) {
            int cnt = 0;
            while (cnt < contentTypes.length) {
                String[] exts = this.getFileSpecs(contentTypes[cnt]);
                if (exts != null) {
                    int sub = 0;
                    while (sub < exts.length) {
                        if (!xmlFileExtensions.contains(exts[sub])) {
                            xmlFileExtensions.add(exts[sub]);
                        }
                        ++sub;
                    }
                }
                ++cnt;
            }
        }
        String[] fileExtensions = new String[xmlFileExtensions.size()];
        xmlFileExtensions.toArray(fileExtensions);
        return fileExtensions;
    }

    private IContentType[] getAllXMLContentTypes() {
        ArrayList<IContentType> arrayList = new ArrayList<IContentType>(Arrays.asList(this.contentTypeManager.getAllContentTypes()));
        ArrayList copyContents = (ArrayList)arrayList.clone();
        for (IContentType contentType : arrayList) {
            if (this.isXMLContentType(contentType)) continue;
            copyContents.remove(contentType);
        }
        IContentType[] contentTypes = new IContentType[copyContents.size()];
        copyContents.toArray(contentTypes);
        return contentTypes;
    }

    private boolean isXMLContentType(IContentType contentType) {
        return contentType.getId().equals(PLATFORM_XMLSOURCE_CONTENTTYPE) || contentType.getId().equals(XMLSOURCE_CONTENTTYPE) || this.isKindOfWTPXML(contentType) || this.isKindOfXMLSource(contentType);
    }

    private boolean isKindOfXMLSource(IContentType contentType) {
        IContentType platformContentType = this.contentTypeManager.getContentType(PLATFORM_XMLSOURCE_CONTENTTYPE);
        boolean returnValue = false;
        if (platformContentType != null) {
            returnValue = contentType.isKindOf(platformContentType);
        }
        return returnValue;
    }

    private boolean isKindOfWTPXML(IContentType contentType) {
        IContentType wtpContentType = this.contentTypeManager.getContentType(XMLSOURCE_CONTENTTYPE);
        boolean returnValue = false;
        if (wtpContentType != null) {
            returnValue = contentType.isKindOf(wtpContentType);
        }
        return returnValue;
    }

    private String[] getFileSpecs(IContentType contentType) {
        return contentType.getFileSpecs(8);
    }
}

