/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.Closeable;
import java.nio.file.Path;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class TreeLockExecutor
implements Closeable {
    private static final Runnable CLOSE = () -> {};
    private final ExecutorService executor;
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final Future<?> future;
    private final Function<String, Path> resolver;

    public TreeLockExecutor(ExecutorService executor, Function<String, Path> resolver) {
        this.executor = executor;
        this.resolver = resolver;
        this.future = executor.submit(this::run);
    }

    public void submit(Runnable work, String ... paths) {
        this.queue.add(work);
    }

    protected void run() {
        while (true) {
            try {
                Runnable work;
                while ((work = this.queue.take()) != CLOSE) {
                    work.run();
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    @Override
    public void close() {
        this.queue.clear();
        this.queue.add(CLOSE);
        try {
            this.future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.future.cancel(true);
    }
}

