/***********************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Actuate Corporation - initial API and implementation
 ***********************************************************************/

package org.eclipse.birt.chart.model.layout.util;

import java.util.List;

import org.eclipse.birt.chart.model.layout.*;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.LayoutPackage;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc --> The <b>Switch </b> for the model's inheritance hierarchy. It supports the call
 * {@link #doSwitch(EObject) doSwitch(object)}to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the inheritance hierarchy until a non-null result is
 * returned, which is the result of the switch. <!-- end-user-doc -->
 * @see org.eclipse.birt.chart.model.layout.LayoutPackage
 * @generated
 */
public class LayoutSwitch<T>
{

	/**
	 * The cached model package
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static LayoutPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public LayoutSwitch( )
	{
		if ( modelPackage == null )
		{
			modelPackage = LayoutPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch( EObject theEObject )
	{
		return doSwitch( theEObject.eClass( ), theEObject );
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch( EClass theEClass, EObject theEObject )
	{
		if ( theEClass.eContainer( ) == modelPackage )
		{
			return doSwitch( theEClass.getClassifierID( ), theEObject );
		}
		else
		{
			List<EClass> eSuperTypes = theEClass.getESuperTypes( );
			return eSuperTypes.isEmpty( ) ? defaultCase( theEObject )
					: doSwitch( eSuperTypes.get( 0 ), theEObject );
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch( int classifierID, EObject theEObject )
	{
		switch ( classifierID )
		{
			case LayoutPackage.BLOCK :
			{
				Block block = (Block) theEObject;
				T result = caseBlock( block );
				if ( result == null )
					result = defaultCase( theEObject );
				return result;
			}
			case LayoutPackage.CLIENT_AREA :
			{
				ClientArea clientArea = (ClientArea) theEObject;
				T result = caseClientArea( clientArea );
				if ( result == null )
					result = defaultCase( theEObject );
				return result;
			}
			case LayoutPackage.LABEL_BLOCK :
			{
				LabelBlock labelBlock = (LabelBlock) theEObject;
				T result = caseLabelBlock( labelBlock );
				if ( result == null )
					result = caseBlock( labelBlock );
				if ( result == null )
					result = defaultCase( theEObject );
				return result;
			}
			case LayoutPackage.LEGEND :
			{
				Legend legend = (Legend) theEObject;
				T result = caseLegend( legend );
				if ( result == null )
					result = caseBlock( legend );
				if ( result == null )
					result = defaultCase( theEObject );
				return result;
			}
			case LayoutPackage.PLOT :
			{
				Plot plot = (Plot) theEObject;
				T result = casePlot( plot );
				if ( result == null )
					result = caseBlock( plot );
				if ( result == null )
					result = defaultCase( theEObject );
				return result;
			}
			case LayoutPackage.TITLE_BLOCK :
			{
				TitleBlock titleBlock = (TitleBlock) theEObject;
				T result = caseTitleBlock( titleBlock );
				if ( result == null )
					result = caseLabelBlock( titleBlock );
				if ( result == null )
					result = caseBlock( titleBlock );
				if ( result == null )
					result = defaultCase( theEObject );
				return result;
			}
			default :
				return defaultCase( theEObject );
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Block</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBlock( Block object )
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Client Area</em>'. <!-- begin-user-doc
	 * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Client Area</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClientArea( ClientArea object )
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Label Block</em>'. <!-- begin-user-doc
	 * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Label Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLabelBlock( LabelBlock object )
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Legend</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Legend</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLegend( Legend object )
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Plot</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Plot</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePlot( Plot object )
	{
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Title Block</em>'. <!-- begin-user-doc
	 * --> This implementation returns null; returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Title Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTitleBlock( TitleBlock object )
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will terminate the switch, but this is the last
	 * case anyway. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase( EObject object )
	{
		return null;
	}

} //LayoutSwitch
