/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.instance;

import java.util.Map;
import org.eclipse.birt.report.engine.api.script.instance.IActionInstance;
import org.eclipse.birt.report.engine.api.script.instance.IDrillThroughInstance;
import org.eclipse.birt.report.engine.content.IDrillThroughAction;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.impl.DrillThroughAction;
import org.eclipse.birt.report.engine.script.internal.instance.DrillThroughInstance;

public class ActionInstance
implements IActionInstance {
    IHyperlinkAction hyperlink;
    IDrillThroughInstance drillThroughInstance;

    ActionInstance(IHyperlinkAction hyperlink) {
        this.hyperlink = hyperlink;
    }

    @Override
    public int getType() {
        return this.hyperlink.getType();
    }

    @Override
    public String getBookmark() {
        if (this.getType() == 2) {
            return this.hyperlink.getBookmark();
        }
        throw new RuntimeException("The action type is not bookmark.");
    }

    @Override
    public void setBookmark(String bookmark) {
        if (bookmark == null || bookmark.equals("")) {
            throw new IllegalArgumentException("Bookmark can not be set to NULL or empty.");
        }
        this.hyperlink.setBookmark(bookmark);
    }

    @Override
    public String getHyperlink() {
        if (this.getType() == 1) {
            return this.hyperlink.getHyperlink();
        }
        throw new RuntimeException("The action type is not hyperlink.");
    }

    @Override
    public void setHyperlink(String hyperlink, String target) {
        if (hyperlink == null || hyperlink.equals("")) {
            throw new IllegalArgumentException("Hyperlink can not be set to NULL or empty.");
        }
        this.hyperlink.setHyperlink(hyperlink, target);
    }

    @Override
    public String getTargetWindow() {
        if (this.getType() == 1 || this.getType() == 1) {
            return this.hyperlink.getTargetWindow();
        }
        throw new RuntimeException("The action type is not hyperlink or drillThrough.");
    }

    @Override
    public IDrillThroughInstance createDrillThrough(String bookmark, boolean isBookmark, String reportName, Map parameterBindings, Map searchCriteria, String target, String format) {
        return this.createDrillThrough(bookmark, isBookmark, reportName, parameterBindings, searchCriteria, target, format, null);
    }

    @Override
    public IDrillThroughInstance createDrillThrough(String bookmark, boolean isBookmark, String reportName, Map parameterBindings, Map searchCriteria, String target, String format, String targetFileType) {
        DrillThroughAction drillThrough = new DrillThroughAction(bookmark, isBookmark, reportName, parameterBindings, searchCriteria, target, format, targetFileType);
        return new DrillThroughInstance(drillThrough);
    }

    @Override
    public IDrillThroughInstance createDrillThrough() {
        DrillThroughAction drillThrough = new DrillThroughAction();
        return new DrillThroughInstance(drillThrough);
    }

    @Override
    public IDrillThroughInstance getDrillThrough() {
        if (this.getType() == 3) {
            IDrillThroughAction drillThrough = this.hyperlink.getDrillThrough();
            if (drillThrough != null && this.drillThroughInstance == null) {
                this.drillThroughInstance = new DrillThroughInstance(drillThrough);
            }
            return this.drillThroughInstance;
        }
        throw new RuntimeException("The action type is not drillThrough.");
    }

    @Override
    public void setDrillThrough(IDrillThroughInstance drillThrough) {
        if (drillThrough != null) {
            if (!(drillThrough instanceof DrillThroughInstance)) {
                throw new IllegalArgumentException("IDrillThroughInstance is illegal.");
            }
        } else {
            throw new IllegalArgumentException("IDrillThroughInstance can not be set to NULL.");
        }
        this.hyperlink.setDrillThrough(((DrillThroughInstance)drillThrough).getDrillThroughAction());
        this.drillThroughInstance = drillThrough;
    }

    IHyperlinkAction getHyperlinkAction() {
        return this.hyperlink;
    }

    @Override
    public void setTooltip(String tooltip) {
        this.hyperlink.setTooltip(tooltip);
    }

    @Override
    public String getTooltip() {
        return this.hyperlink.getTooltip();
    }
}

