/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.ICygwinToolsFactroy;
import org.eclipse.cdt.utils.NM;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.coff.parser.CygwinSymbol;
import org.eclipse.cdt.utils.coff.parser.PEBinaryObject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CygwinPEBinaryObject
extends PEBinaryObject {
    private Addr2line autoDisposeAddr2line;
    private Addr2line symbolLoadingAddr2line;
    private CygPath symbolLoadingCygPath;
    private CPPFilt symbolLoadingCPPFilt;
    long starttime;

    public CygwinPEBinaryObject(IBinaryParser parser, IPath path, AR.ARHeader header) {
        super(parser, path, header);
    }

    public CygwinPEBinaryObject(IBinaryParser parser, IPath path, int type) {
        super(parser, path, type);
    }

    public Addr2line getAddr2line(boolean autodisposing) {
        if (!autodisposing) {
            return this.getAddr2line();
        }
        if (this.autoDisposeAddr2line == null) {
            this.autoDisposeAddr2line = this.getAddr2line();
            if (this.autoDisposeAddr2line != null) {
                this.starttime = System.currentTimeMillis();
                Runnable worker = new Runnable(){

                    @Override
                    public void run() {
                        long diff = System.currentTimeMillis() - CygwinPEBinaryObject.this.starttime;
                        while (diff < 10000L) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                            diff = System.currentTimeMillis() - CygwinPEBinaryObject.this.starttime;
                        }
                        CygwinPEBinaryObject.this.stopAddr2Line();
                    }
                };
                new Thread(worker, "Addr2line Reaper").start();
            }
        } else {
            this.starttime = System.currentTimeMillis();
        }
        return this.autoDisposeAddr2line;
    }

    synchronized void stopAddr2Line() {
        if (this.autoDisposeAddr2line != null) {
            this.autoDisposeAddr2line.dispose();
        }
        this.autoDisposeAddr2line = null;
    }

    private Addr2line getAddr2line() {
        ICygwinToolsFactroy factory = (ICygwinToolsFactroy)this.getBinaryParser().getAdapter(ICygwinToolsFactroy.class);
        if (factory != null) {
            return factory.getAddr2line(this.getPath());
        }
        return null;
    }

    protected CPPFilt getCPPFilt() {
        ICygwinToolsFactroy factory = (ICygwinToolsFactroy)this.getBinaryParser().getAdapter(ICygwinToolsFactroy.class);
        if (factory != null) {
            return factory.getCPPFilt();
        }
        return null;
    }

    protected Objdump getObjdump() {
        ICygwinToolsFactroy factory = (ICygwinToolsFactroy)this.getBinaryParser().getAdapter(ICygwinToolsFactroy.class);
        if (factory != null) {
            return factory.getObjdump(this.getPath());
        }
        return null;
    }

    protected CygPath getCygPath() {
        ICygwinToolsFactroy factory = (ICygwinToolsFactroy)this.getBinaryParser().getAdapter(ICygwinToolsFactroy.class);
        if (factory != null) {
            return factory.getCygPath();
        }
        return null;
    }

    protected NM getNM() {
        ICygwinToolsFactroy factory = (ICygwinToolsFactroy)this.getBinaryParser().getAdapter(ICygwinToolsFactroy.class);
        if (factory != null) {
            return factory.getNM(this.getPath());
        }
        return null;
    }

    @Override
    public InputStream getContents() throws IOException {
        InputStream stream = null;
        Objdump objdump = this.getObjdump();
        if (objdump != null) {
            try {
                byte[] contents = objdump.getOutput();
                stream = new ByteArrayInputStream(contents);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (stream == null) {
            stream = super.getContents();
        }
        return stream;
    }

    @Override
    protected void loadSymbols(PE pe) throws IOException {
        this.symbolLoadingAddr2line = this.getAddr2line(false);
        this.symbolLoadingCPPFilt = this.getCPPFilt();
        this.symbolLoadingCygPath = this.getCygPath();
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        super.loadSymbols(pe, list);
        NM nm = this.getNM();
        if (nm != null) {
            NM.AddressNamePair[] pairs = nm.getBSSSymbols();
            int i = 0;
            while (i < pairs.length) {
                this.addSymbol(pairs[i], list, 2);
                ++i;
            }
            pairs = nm.getDataSymbols();
            i = 0;
            while (i < pairs.length) {
                this.addSymbol(pairs[i], list, 2);
                ++i;
            }
        }
        this.symbols = list.toArray(NO_SYMBOLS);
        Arrays.sort(this.symbols);
        list.clear();
        if (this.symbolLoadingAddr2line != null) {
            this.symbolLoadingAddr2line.dispose();
            this.symbolLoadingAddr2line = null;
        }
        if (this.symbolLoadingCPPFilt != null) {
            this.symbolLoadingCPPFilt.dispose();
            this.symbolLoadingCPPFilt = null;
        }
        if (this.symbolLoadingCygPath != null) {
            this.symbolLoadingCygPath.dispose();
            this.symbolLoadingCygPath = null;
        }
    }

    private void addSymbol(NM.AddressNamePair p, List<Symbol> list, int type) {
        String name = p.name;
        if (name != null && name.length() > 0 && CConventions.isValidIdentifier(name)) {
            Addr32 addr = new Addr32(p.address);
            int size = 4;
            if (this.symbolLoadingCPPFilt != null) {
                try {
                    name = this.symbolLoadingCPPFilt.getFunction(name);
                }
                catch (IOException e1) {
                    this.symbolLoadingCPPFilt.dispose();
                    this.symbolLoadingCPPFilt = null;
                }
            }
            if (this.symbolLoadingAddr2line != null) {
                try {
                    String filename = this.symbolLoadingAddr2line.getFileName(addr);
                    if (filename != null && filename.equals("??")) {
                        filename = null;
                    }
                    if (filename != null) {
                        try {
                            if (this.symbolLoadingCygPath != null) {
                                filename = this.symbolLoadingCygPath.getFileName(filename);
                            }
                        }
                        catch (IOException e) {
                            this.symbolLoadingCygPath.dispose();
                            this.symbolLoadingCygPath = null;
                        }
                    }
                    Path file = filename != null ? new Path(filename) : Path.EMPTY;
                    int startLine = this.symbolLoadingAddr2line.getLineNumber(addr);
                    int endLine = this.symbolLoadingAddr2line.getLineNumber(addr.add(size - 1));
                    list.add(new CygwinSymbol(this, name, type, (IAddress)addr, (long)size, (IPath)file, startLine, endLine));
                }
                catch (IOException e) {
                    this.symbolLoadingAddr2line.dispose();
                    this.symbolLoadingAddr2line = null;
                }
            }
        }
    }

    @Override
    protected void addSymbols(Coff.Symbol[] peSyms, byte[] table, List<Symbol> list) {
        Coff.Symbol[] symbolArray = peSyms;
        int n = peSyms.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Coff.Symbol peSym = symbolArray[n2];
            if ((peSym.isFunction() || peSym.isPointer() || peSym.isArray()) && (name = peSym.getName(table)) != null && name.trim().length() != 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
                int type = peSym.isFunction() ? 1 : 2;
                Addr32 addr = new Addr32(peSym.n_value);
                int size = 4;
                if (this.symbolLoadingCPPFilt != null) {
                    try {
                        name = this.symbolLoadingCPPFilt.getFunction(name);
                    }
                    catch (IOException e1) {
                        this.symbolLoadingCPPFilt.dispose();
                        this.symbolLoadingCPPFilt = null;
                    }
                }
                if (this.symbolLoadingAddr2line != null) {
                    try {
                        String filename = this.symbolLoadingAddr2line.getFileName(addr);
                        if (filename != null && filename.equals("??")) {
                            filename = null;
                        }
                        if (filename != null) {
                            try {
                                if (this.symbolLoadingCygPath != null) {
                                    filename = this.symbolLoadingCygPath.getFileName(filename);
                                }
                            }
                            catch (IOException e) {
                                this.symbolLoadingCygPath.dispose();
                                this.symbolLoadingCygPath = null;
                            }
                        }
                        Path file = filename != null ? new Path(filename) : Path.EMPTY;
                        int startLine = this.symbolLoadingAddr2line.getLineNumber(addr);
                        int endLine = this.symbolLoadingAddr2line.getLineNumber(addr.add(size - 1));
                        list.add(new CygwinSymbol(this, name, type, (IAddress)addr, (long)size, (IPath)file, startLine, endLine));
                    }
                    catch (IOException e) {
                        this.symbolLoadingAddr2line.dispose();
                        this.symbolLoadingAddr2line = null;
                        list.add(new CygwinSymbol(this, name, type, (IAddress)addr, (long)size));
                    }
                } else {
                    list.add(new CygwinSymbol(this, name, type, (IAddress)addr, (long)size));
                }
            }
            ++n2;
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == Addr2line.class) {
            return (T)this.getAddr2line(false);
        }
        if (adapter == CPPFilt.class) {
            return (T)this.getCPPFilt();
        }
        if (adapter == CygPath.class) {
            return (T)this.getCygPath();
        }
        return super.getAdapter(adapter);
    }
}

