/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui.corebuild;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.debug.core.launch.CoreBuildLaunchConfigDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.ui.ILaunchBarLaunchConfigDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class CommonBuildTab
extends AbstractLaunchConfigurationTab {
    private Combo tcCombo;
    private ICBuildConfiguration buildConfig;
    private IToolChain[] toolchains;
    private IToolChain currentToolchain;
    private IProject project;
    private Map<ICBuildConfiguration, Map<String, String>> savedProperties = new HashMap<ICBuildConfiguration, Map<String, String>>();
    private static IToolChainManager tcManager = LaunchUIPlugin.getService(IToolChainManager.class);
    private static ICBuildConfigurationManager bcManager = LaunchUIPlugin.getService(ICBuildConfigurationManager.class);

    protected String getBuildConfigProviderId() {
        return null;
    }

    protected void saveProperties(Map<String, String> properties) {
    }

    protected void restoreProperties(Map<String, String> properties) {
    }

    protected Control createToolchainSelector(Composite parent) {
        Group tcGroup = new Group(parent, 0);
        tcGroup.setText(LaunchMessages.CommonBuildTab_Toolchain);
        tcGroup.setLayout((Layout)new GridLayout());
        this.tcCombo = new Combo((Composite)tcGroup, 8);
        this.tcCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tcCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Map<String, String> saved;
                if (CommonBuildTab.this.buildConfig != null) {
                    saved = new HashMap<String, String>();
                    CommonBuildTab.this.saveProperties(saved);
                    CommonBuildTab.this.savedProperties.put(CommonBuildTab.this.buildConfig, saved);
                }
                if (CommonBuildTab.this.toolchainChanged() && (saved = (Map)CommonBuildTab.this.savedProperties.get(CommonBuildTab.this.buildConfig)) != null) {
                    CommonBuildTab.this.restoreProperties(saved);
                }
            }
        });
        return tcGroup;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.tcCombo == null) {
            return;
        }
        try {
            String typeId;
            IToolChain toolchain;
            this.project = CoreBuildLaunchConfigDelegate.getProject((ILaunchConfiguration)configuration);
            ICBuildConfigurationProvider bcProvider = bcManager.getProvider(this.getBuildConfigProviderId());
            ILaunchTarget target = this.getLaunchTarget();
            this.toolchains = bcProvider.getSupportedToolchains(tcManager.getToolChainsMatching(target.getAttributes())).toArray(new IToolChain[0]);
            this.tcCombo.removeAll();
            if (this.toolchains.length > 0) {
                this.tcCombo.add(String.format(LaunchMessages.CommonBuildTab_Default, this.toolchains[0].getName()));
            } else {
                this.tcCombo.add(LaunchMessages.CommonBuildTab_NotFound);
            }
            IToolChain[] iToolChainArray = this.toolchains;
            int n = this.toolchains.length;
            int n2 = 0;
            while (n2 < n) {
                IToolChain tc = iToolChainArray[n2];
                this.tcCombo.add(tc.getName());
                ++n2;
            }
            this.tcCombo.select(0);
            String toolchainId = configuration.getAttribute("cdt.toolChain.id", null);
            if (toolchainId != null && (toolchain = tcManager.getToolChain(typeId = configuration.getAttribute("cdt.toolChain.type", ""), toolchainId)) != null) {
                int i = 0;
                while (i < this.toolchains.length) {
                    if (this.toolchains[i] == toolchain) {
                        this.tcCombo.select(i + 1);
                        break;
                    }
                    ++i;
                }
            }
            this.toolchainChanged();
        }
        catch (CoreException e) {
            LaunchUIPlugin.log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.tcCombo == null) {
            return;
        }
        int i = this.tcCombo.getSelectionIndex();
        if (i == 0) {
            configuration.removeAttribute("cdt.toolChain.id");
            configuration.removeAttribute("cdt.toolChain.type");
        } else {
            IToolChain tc = this.toolchains[i - 1];
            configuration.setAttribute("cdt.toolChain.id", tc.getId());
            configuration.setAttribute("cdt.toolChain.type", tc.getTypeId());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.removeAttribute("cdt.toolChain.id");
        configuration.removeAttribute("cdt.toolChain.type");
    }

    private boolean toolchainChanged() {
        IToolChain newToolchain;
        int i = this.tcCombo.getSelectionIndex();
        if (i < 0 || this.toolchains.length == 0) {
            this.buildConfig = null;
            return false;
        }
        if (i == 0) {
            i = 1;
        }
        if ((newToolchain = this.toolchains[i - 1]) == this.currentToolchain) {
            return false;
        }
        this.currentToolchain = newToolchain;
        String mode = this.getLaunchConfigurationDialog().getMode();
        try {
            this.buildConfig = bcManager.getBuildConfiguration(this.project, newToolchain, mode, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LaunchUIPlugin.log(e.getStatus());
        }
        return true;
    }

    public ILaunchBarLaunchConfigDialog getLaunchBarLaunchConfigDialog() {
        ILaunchConfigurationDialog dialog = this.getLaunchConfigurationDialog();
        return dialog instanceof ILaunchBarLaunchConfigDialog ? (ILaunchBarLaunchConfigDialog)dialog : null;
    }

    public ILaunchTarget getLaunchTarget() {
        ILaunchBarLaunchConfigDialog dialog = this.getLaunchBarLaunchConfigDialog();
        return dialog != null ? dialog.getLaunchTarget() : null;
    }

    @Deprecated
    public ICBuildConfiguration getBuildConfiguration(ILaunchConfiguration configuration) throws CoreException {
        return this.buildConfig;
    }

    public ICBuildConfiguration getBuildConfiguration() {
        return this.buildConfig;
    }
}

