/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.actions.EditorAction;
import org.eclipse.cft.server.ui.internal.editor.ApplicationDetailsPart;
import org.eclipse.cft.server.ui.internal.editor.ApplicationMasterPart;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.server.core.IModule;

public class ApplicationMasterDetailsBlock
extends MasterDetailsBlock
implements IDetailsPageProvider {
    private final CloudFoundryServer cloudServer;
    private ApplicationDetailsPart detailsPart;
    private final CloudFoundryApplicationsEditorPage editorPage;
    private ApplicationMasterPart masterPart;

    public ApplicationMasterDetailsBlock(CloudFoundryApplicationsEditorPage editorPage, CloudFoundryServer cloudServer) {
        this.editorPage = editorPage;
        this.cloudServer = cloudServer;
    }

    public void createContent(IManagedForm managedForm) {
        super.createContent(managedForm);
        this.sashForm.setWeights(new int[]{50, 50});
    }

    public IModule getCurrentModule() {
        return this.getMasterPart().getCurrentModule();
    }

    public ApplicationDetailsPart getDetailsPage() {
        if (this.detailsPart == null) {
            this.detailsPart = new ApplicationDetailsPart(this.editorPage, this.cloudServer);
        }
        return this.detailsPart;
    }

    public ApplicationMasterPart getMasterPart() {
        return this.masterPart;
    }

    public IDetailsPage getPage(Object key) {
        return this.getDetailsPage();
    }

    public Object getPageKey(Object object) {
        if (object == null) {
            return null;
        }
        return ((Object)((Object)this)).getClass();
    }

    public void refreshUI(EditorAction.RefreshArea area) {
        if (area == EditorAction.RefreshArea.MASTER || area == EditorAction.RefreshArea.ALL) {
            this.masterPart.refreshUI();
        }
        if ((area == EditorAction.RefreshArea.DETAIL || area == EditorAction.RefreshArea.ALL) && this.detailsPart != null) {
            this.detailsPart.refreshUI();
        }
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite container = toolkit.createComposite(parent);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, false, true));
        this.masterPart = new ApplicationMasterPart(this.editorPage, managedForm, container, this.cloudServer);
        managedForm.addPart((IFormPart)this.masterPart);
        this.masterPart.createContents();
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageProvider((IDetailsPageProvider)this);
    }
}

