/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.IOException;
import java.text.MessageFormat;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public class BitFlagsQuery
extends Query {
    private final int fTrueFlags;
    private final int fFalseFlags;

    public BitFlagsQuery(int trueFlags, int falseFlags) {
        this.fTrueFlags = trueFlags;
        this.fFalseFlags = falseFlags;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fFalseFlags;
        result = 31 * result + this.fTrueFlags;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BitFlagsQuery other = (BitFlagsQuery)((Object)obj);
        if (this.fFalseFlags != other.fFalseFlags) {
            return false;
        }
        return this.fTrueFlags == other.fTrueFlags;
    }

    public String toString(String input) {
        return MessageFormat.format("BitFlagsQuery(Field: {0}, True Flags: {1}, False Flags: {2})", "flagsNDV", this.fTrueFlags, this.fFalseFlags);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new ConstantScoreWeight(this, 10.0f){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final NumericDocValues fields = context.reader().getNumericDocValues("flagsNDV");
                if (fields == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator((DocIdSetIterator)fields){

                    public boolean matches() throws IOException {
                        long flags = fields.longValue();
                        if (BitFlagsQuery.this.fTrueFlags != 0 && (flags & (long)BitFlagsQuery.this.fTrueFlags) == 0L) {
                            return false;
                        }
                        return BitFlagsQuery.this.fFalseFlags == 0 || (flags & (long)BitFlagsQuery.this.fFalseFlags) == 0L;
                    }

                    public float matchCost() {
                        return 2.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, 10.0f, iterator);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{"flagsNDV"});
            }
        };
    }
}

