/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.compiler.problem.DefaultProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.IProblemSeverityTranslator;
import org.eclipse.dltk.compiler.problem.ProblemCategory;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension2;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension3;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension4;
import org.eclipse.dltk.core.builder.IBuildParticipantFilter;
import org.eclipse.dltk.core.builder.IBuildState;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.internal.core.builder.BuildParticipantManager;
import org.eclipse.dltk.internal.core.builder.BuildProblemReporter;
import org.eclipse.dltk.internal.core.builder.ExternalModuleBuildContext;
import org.eclipse.dltk.internal.core.builder.Messages;
import org.eclipse.dltk.internal.core.builder.SourceModuleBuildContext;
import org.eclipse.dltk.internal.core.builder.SubTaskProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class StandardScriptBuilder
implements IScriptBuilder {
    private static final boolean DEBUG = false;
    private static final int WORK_BUILD = 100;
    private static final int PARALLEL_THRESHOLD = 10;
    private List<IProblemReporter> fReporters = null;
    private boolean beginBuildDone = false;
    private boolean endBuildNeeded = false;
    private IBuildParticipant[] participants = null;
    private Map<IBuildParticipant, List<IBuildParticipant>> participantDependencies = null;
    private IBuildParticipantFilter[] filters = null;
    private IDLTKLanguageToolkit toolkit = null;
    private IProblemFactory problemFactory = null;

    @Override
    public void prepare(IBuildChange change, IBuildState state, IProgressMonitor monitor) throws CoreException {
        if (this.participants != null) {
            int i = 0;
            while (i < this.participants.length) {
                IBuildParticipant participant = this.participants[i];
                if (participant instanceof IBuildParticipantExtension2) {
                    ((IBuildParticipantExtension2)((Object)participant)).prepare(change, state);
                }
                ++i;
            }
        }
    }

    @Override
    public void build(IBuildChange change, IBuildState state, IProgressMonitor monitor) throws CoreException {
        List<IFile> resourceChanges;
        this.buildExternalElements(change, monitor);
        if (this.toolkit != null) {
            this.buildNatureModules(change.getScriptProject(), change.getBuildType(), change.getSourceModules(0), state, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)100));
        }
        if (!(resourceChanges = change.getResources(0)).isEmpty()) {
            this.buildResources(resourceChanges, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private void buildExternalElements(IBuildChange change, IProgressMonitor monitor) throws CoreException {
        int buildType = change.getBuildType();
        this.beginBuild(buildType, monitor);
        List<IBuildParticipantExtension2> extensions = this.selectExtension(IBuildParticipantExtension2.class);
        if (extensions != null) {
            List<ISourceModule> externalElements = change.getExternalModules(0);
            int remainingWork = externalElements.size();
            for (ISourceModule module : externalElements) {
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask(NLS.bind((String)Messages.ValidatorBuilder_buildExternalModuleSubTask, (Object)String.valueOf(remainingWork), (Object)module.getElementName()));
                ExternalModuleBuildContext context = new ExternalModuleBuildContext(module, buildType);
                try {
                    int i = 0;
                    while (i < extensions.size()) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        extensions.get(i).buildExternalModule(context);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    DLTKCore.error(NLS.bind((String)Messages.StandardScriptBuilder_errorBuildingExternalModule, (Object)module.getElementName()), e);
                }
                --remainingWork;
            }
        }
    }

    private <T> List<T> selectExtension(Class<T> clazz) {
        if (this.participants != null) {
            int count = 0;
            int i = 0;
            while (i < this.participants.length) {
                IBuildParticipant participant = this.participants[i];
                if (clazz.isInstance(participant)) {
                    ++count;
                }
                ++i;
            }
            if (count != 0) {
                ArrayList<IBuildParticipant> result = new ArrayList<IBuildParticipant>(count);
                int i2 = 0;
                while (i2 < this.participants.length) {
                    IBuildParticipant participant = this.participants[i2];
                    if (clazz.isInstance(participant)) {
                        IBuildParticipant casted = participant;
                        result.add(casted);
                    }
                    ++i2;
                }
                return result;
            }
        }
        return null;
    }

    private void buildNatureModules(IScriptProject project, int buildType, List<ISourceModule> modules, IBuildState state, IProgressMonitor monitor) {
        long startTime = 0L;
        this.beginBuild(buildType, monitor);
        monitor.beginTask(Messages.ValidatorBuilder_buildingModules, modules.size());
        try {
            if (this.participants.length == 0 || modules.isEmpty()) {
                return;
            }
            if (this.fReporters == null) {
                this.fReporters = Collections.synchronizedList(new ArrayList(modules.size()));
            }
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            if (modules.size() >= 10 && availableProcessors > 2) {
                this.processInParallel(modules, buildType, state, project, monitor);
            } else {
                this.processInSingleThread(modules, buildType, state, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void processInSingleThread(List<ISourceModule> modules, int buildType, IBuildState state, IProgressMonitor monitor) {
        int numberOfScannedFiles = 0;
        Iterator<ISourceModule> j = modules.iterator();
        while (j.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            ISourceModule module = j.next();
            monitor.subTask(NLS.bind((String)Messages.ValidatorBuilder_buildModuleSubTask, (Object)((int)((float)numberOfScannedFiles * 100.0f / (float)modules.size())), (Object)module.getElementName()));
            this.processModule(module, buildType, state);
            monitor.worked(1);
            ++numberOfScannedFiles;
        }
    }

    private void processInParallel(List<ISourceModule> modules, int buildType, IBuildState state, IScriptProject project, IProgressMonitor monitor) {
        ArrayBlockingQueue<ISourceModule> queue = new ArrayBlockingQueue<ISourceModule>(modules.size(), true, modules);
        int maxThreads = Math.min(modules.size() / 2, Runtime.getRuntime().availableProcessors());
        ArrayList<BuildModulesJob> jobs = new ArrayList<BuildModulesJob>(maxThreads);
        try {
            int i = 0;
            while (i < maxThreads) {
                BuildModulesJob job = new BuildModulesJob(queue, buildType, state);
                job.schedule();
                jobs.add(job);
                ++i;
            }
            int lastNumberOfScannedFiles = 0;
            for (BuildModulesJob job : jobs) {
                while (!job.join(100L, null)) {
                    if (monitor.isCanceled()) {
                        for (Job job2 : jobs) {
                            job2.cancel();
                        }
                        continue;
                    }
                    int n = modules.size() - queue.size();
                    monitor.subTask(NLS.bind((String)Messages.ValidatorBuilder_buildModuleSubTask, (Object)((int)((float)n * 100.0f / (float)modules.size())), (Object)project.getElementName()));
                    int steps = n - lastNumberOfScannedFiles;
                    monitor.worked(steps);
                    lastNumberOfScannedFiles += steps;
                }
            }
        }
        catch (OperationCanceledException e) {
            DLTKCore.error(e);
        }
        catch (InterruptedException e) {
            DLTKCore.error(e);
        }
    }

    private void processModule(ISourceModule module, int buildType, IBuildState state) {
        SourceModuleBuildContext context = new SourceModuleBuildContext(this.problemFactory, module, buildType, state);
        if (context.reporter != null) {
            this.buildModule(context);
            this.fReporters.add(context.reporter);
        }
    }

    private void beginBuild(int buildType, IProgressMonitor monitor) {
        if (!this.beginBuildDone) {
            monitor.subTask(Messages.ValidatorBuilder_InitializeBuilders);
            this.endBuildNeeded = false;
            int count = 0;
            int j = 0;
            while (j < this.participants.length) {
                boolean useParticipant;
                IBuildParticipant participant = this.participants[j];
                if (participant instanceof IBuildParticipantExtension) {
                    useParticipant = ((IBuildParticipantExtension)((Object)participant)).beginBuild(buildType);
                    this.endBuildNeeded = true;
                } else {
                    useParticipant = true;
                }
                if (useParticipant) {
                    if (count < j) {
                        this.participants[count] = this.participants[j];
                    }
                    ++count;
                }
                ++j;
            }
            this.participants = BuildParticipantManager.copyFirst(this.participants, count);
            BuildParticipantManager.notifyDependents(this.participants, this.participantDependencies);
            this.beginBuildDone = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void buildModule(IBuildContext context) {
        block14: {
            block13: {
                selected = this.participants;
                var6_3 = this.filters;
                var5_7 = this.filters.length;
                var4_11 = 0;
                while (var4_11 < var5_7) {
                    filter = var6_3[var4_11];
                    if ((selected = filter.filter(selected, context)) == null || selected.length == 0) {
                        return;
                    }
                    ++var4_11;
                }
                try {
                    try {
                        k = 0;
                        while (k < selected.length) {
                            selected[k].build(context);
                            ++k;
                        }
                        break block13;
                    }
                    catch (CoreException e) {
                        DLTKCore.error(Messages.StandardScriptBuilder_errorBuildingModule, e);
                        var8_16 = this.participants;
                        var7_19 = this.participants.length;
                        var6_4 = 0;
                        ** while (var6_4 < var7_19)
                    }
                }
                catch (Throwable var4_12) {
                    var8_17 = this.participants;
                    var7_20 = this.participants.length;
                    var6_5 = 0;
                    ** while (var6_5 < var7_20)
                }
lbl-1000:
                // 1 sources

                {
                    participant = var8_16[var6_4];
                    if (participant instanceof IBuildParticipantExtension4) {
                        ((IBuildParticipantExtension4)participant).afterBuild(context);
                    }
                    ++var6_4;
                    continue;
lbl30:
                    // 1 sources

                    break block14;
                }
lbl-1000:
                // 1 sources

                {
                    participant = var8_17[var6_5];
                    if (participant instanceof IBuildParticipantExtension4) {
                        ((IBuildParticipantExtension4)participant).afterBuild(context);
                    }
                    ++var6_5;
                    continue;
                }
lbl41:
                // 1 sources

                throw var4_12;
            }
            var8_18 = this.participants;
            var7_21 = this.participants.length;
            var6_6 = 0;
            while (var6_6 < var7_21) {
                participant = var8_18[var6_6];
                if (participant instanceof IBuildParticipantExtension4) {
                    ((IBuildParticipantExtension4)participant).afterBuild(context);
                }
                ++var6_6;
            }
        }
    }

    protected IStatus buildResources(List<IFile> resources, IProgressMonitor monitor) {
        try {
            monitor.beginTask("", resources.size());
            try {
                for (IFile resource : resources) {
                    monitor.subTask(NLS.bind((String)Messages.ValidatorBuilder_clearingResourceMarkers, (Object)resource.getName()));
                    this.problemFactory.deleteMarkers((IResource)resource);
                    monitor.worked(1);
                }
            }
            catch (CoreException e) {
                String msg = Messages.ValidatorBuilder_errorDeleteResourceMarkers;
                DLTKCore.error(msg, e);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    @Override
    public void clean(IScriptProject project, IProgressMonitor monitor) {
        List<IBuildParticipantExtension3> extensions = this.selectExtension(IBuildParticipantExtension3.class);
        if (extensions != null) {
            for (IBuildParticipantExtension3 extension : extensions) {
                extension.clean();
            }
        }
        IProject p = project.getProject();
        try {
            this.problemFactory.deleteMarkers((IResource)p);
        }
        catch (CoreException e) {
            DLTKCore.error(NLS.bind((String)Messages.StandardScriptBuilder_errorCleaning, (Object)p.getName()), e);
        }
    }

    protected IDLTKLanguageToolkit getLanguageToolkit() {
        return this.toolkit;
    }

    @Override
    public boolean initialize(IScriptProject project) {
        this.toolkit = project.getLanguageToolkit();
        if (this.toolkit != null) {
            BuildParticipantManager.BuildParticipantResult result = BuildParticipantManager.getBuildParticipants(project, this.toolkit.getNatureId());
            this.participants = result.participants;
            this.participantDependencies = result.dependencies;
        }
        if (this.participants == null || this.participants.length == 0) {
            return false;
        }
        this.filters = BuildParticipantManager.getFilters(project, this.toolkit.getNatureId(), this);
        this.problemFactory = this.createProblemFactory();
        this.beginBuildDone = false;
        this.endBuildNeeded = false;
        return true;
    }

    protected IProblemFactory createProblemFactory() {
        if (this.toolkit != null) {
            return DLTKLanguageManager.getProblemFactory(this.toolkit.getNatureId());
        }
        return new DefaultProblemFactory();
    }

    @Override
    public void endBuild(IScriptProject project, IBuildState state, IProgressMonitor monitor) {
        if (this.endBuildNeeded) {
            monitor.subTask(Messages.ValidatorBuilder_finalizeBuild);
            SubTaskProgressMonitor finalizeMonitor = new SubTaskProgressMonitor(monitor, Messages.ValidatorBuilder_finalizeBuild);
            int j = 0;
            while (j < this.participants.length) {
                IBuildParticipant participant = this.participants[j];
                if (participant instanceof IBuildParticipantExtension) {
                    ((IBuildParticipantExtension)((Object)participant)).endBuild((IProgressMonitor)finalizeMonitor);
                }
                ++j;
            }
            this.endBuildNeeded = false;
        }
        if (this.fReporters != null) {
            IProblemSeverityTranslator severityTranslator = this.problemFactory.createSeverityTranslator(project);
            for (IProblemReporter reporter : this.fReporters) {
                BuildProblemReporter buildReporter = (BuildProblemReporter)reporter;
                if (buildReporter.hasCategory(ProblemCategory.IMPORT)) {
                    state.recordImportProblem(buildReporter.resource.getFullPath());
                }
                buildReporter.flush(severityTranslator);
            }
            this.fReporters = null;
        }
        this.participants = null;
        this.participantDependencies = null;
        this.filters = null;
        this.toolkit = null;
        this.problemFactory = null;
        this.beginBuildDone = false;
    }

    private class BuildModulesJob
    extends Job {
        private Queue<ISourceModule> modules;
        private int buildType;
        private IBuildState state;

        public BuildModulesJob(Queue<ISourceModule> modules, int buildType, IBuildState state) {
            super("Build Modules");
            this.setSystem(true);
            this.modules = modules;
            this.buildType = buildType;
            this.state = state;
        }

        protected IStatus run(IProgressMonitor monitor) {
            ISourceModule module;
            while ((module = this.modules.poll()) != null) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                StandardScriptBuilder.this.processModule(module, this.buildType, this.state);
            }
            return Status.OK_STATUS;
        }
    }
}

