/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.DeletePathsOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.DeleteResourceAction;

public class DeletePathsOperationUI {
    private final Collection<IPath> paths;
    private final IShellProvider shellProvider;

    public DeletePathsOperationUI(Collection<IPath> paths, IShellProvider shellProvider) {
        this.paths = paths;
        this.shellProvider = shellProvider;
    }

    public void run() {
        List<IResource> resources = this.getSelectedResourcesIfAllExist();
        if (resources != null) {
            this.runNormalAction(resources);
        } else {
            this.runNonWorkspaceAction();
        }
    }

    private void runNormalAction(List<IResource> resources) {
        DeleteResourceAction action = new DeleteResourceAction(this.shellProvider);
        StructuredSelection selection = new StructuredSelection(resources);
        action.selectionChanged((IStructuredSelection)selection);
        action.run();
    }

    private String[] getButtonLabels() {
        return new String[]{UIText.DeletePathsOperationUI_ButtonOK, IDialogConstants.CANCEL_LABEL};
    }

    private boolean openConfirm(Shell parent, String title, String message) {
        MessageDialog dialog = new MessageDialog(parent, title, null, message, 5, 0, this.getButtonLabels());
        return dialog.open() == 0;
    }

    private void runNonWorkspaceAction() {
        boolean performAction = this.openConfirm(this.shellProvider.getShell(), UIText.DeleteResourcesOperationUI_confirmActionTitle, UIText.DeleteResourcesOperationUI_confirmActionMessage);
        if (!performAction) {
            return;
        }
        DeletePathsOperation operation = new DeletePathsOperation(this.paths);
        try {
            operation.execute(null);
        }
        catch (CoreException e) {
            Activator.handleError(UIText.DeleteResourcesOperationUI_deleteFailed, e, true);
        }
    }

    private List<IResource> getSelectedResourcesIfAllExist() {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (IPath path : this.paths) {
            IResource resource = ResourceUtil.getResourceForLocation((IPath)path, (boolean)false);
            if (resource != null) {
                resources.add(resource);
                continue;
            }
            return null;
        }
        return resources;
    }
}

