/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.Viewer;

public final class CDOCheckoutViewerRefresh
extends AdapterFactoryContentProvider.ViewerRefresh {
    private final Viewer viewer;

    public CDOCheckoutViewerRefresh(Viewer viewer) {
        super(viewer);
        this.viewer = viewer;
    }

    public boolean addNotification(Object element, boolean contentRefresh, boolean labelUpdate) {
        return this.addNotification(element, contentRefresh, labelUpdate, null);
    }

    public boolean addNotification(Object element, boolean contentRefresh, boolean labelUpdate, Runnable runnable) {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            Object notification;
            if (runnable != null) {
                RunnableViewerNotification n = new RunnableViewerNotification(element, contentRefresh, labelUpdate);
                n.getRunnables().add(runnable);
                notification = n;
            } else {
                notification = new ViewerNotification(null, element, contentRefresh, labelUpdate);
            }
            if (this.addNotification((IViewerNotification)notification)) {
                this.viewer.getControl().getDisplay().asyncExec((Runnable)((Object)this));
                return true;
            }
        }
        return false;
    }

    protected IViewerNotification merge(IViewerNotification n1, IViewerNotification n2) {
        IViewerNotification result;
        RunnableViewerNotification n;
        List<Runnable> list;
        ArrayList<Runnable> runnables = null;
        if (n1 instanceof RunnableViewerNotification && !(list = (n = (RunnableViewerNotification)n1).getRunnables()).isEmpty()) {
            runnables = new ArrayList<Runnable>(list);
        }
        if (n2 instanceof RunnableViewerNotification && !(list = (n = (RunnableViewerNotification)n2).getRunnables()).isEmpty()) {
            if (runnables == null) {
                runnables = new ArrayList<Runnable>(list);
            } else {
                runnables.addAll(list);
            }
        }
        if ((result = super.merge(n1, n2)) != null && runnables != null) {
            if (result instanceof RunnableViewerNotification) {
                RunnableViewerNotification n3 = (RunnableViewerNotification)result;
                List<Runnable> list2 = n3.getRunnables();
                list2.clear();
                list2.addAll(runnables);
            } else {
                RunnableViewerNotification newResult = new RunnableViewerNotification(result.getElement(), result.isContentRefresh(), result.isLabelUpdate());
                newResult.getRunnables().addAll(runnables);
                result = newResult;
            }
        }
        return result;
    }

    protected void refresh(IViewerNotification notification) {
        super.refresh(notification);
        if (notification instanceof RunnableViewerNotification) {
            RunnableViewerNotification n = (RunnableViewerNotification)notification;
            n.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RunnableViewerNotification
    implements IViewerNotification,
    Runnable {
        private final List<Runnable> runnables = new ArrayList<Runnable>();
        private final Object element;
        private final boolean contentRefresh;
        private final boolean labelUpdate;

        public RunnableViewerNotification(Object element, boolean contentRefresh, boolean labelUpdate) {
            this.element = element;
            this.contentRefresh = contentRefresh;
            this.labelUpdate = labelUpdate;
        }

        public int getEventType() {
            return 1;
        }

        public Object getNotifier() {
            return this.element;
        }

        public int getFeatureID(Class<?> expectedClass) {
            return 0;
        }

        public Object getFeature() {
            return null;
        }

        public Object getOldValue() {
            return null;
        }

        public Object getNewValue() {
            return null;
        }

        public boolean wasSet() {
            return false;
        }

        public boolean isTouch() {
            return false;
        }

        public boolean isReset() {
            return false;
        }

        public int getPosition() {
            return 0;
        }

        public boolean merge(Notification notification) {
            return false;
        }

        public boolean getOldBooleanValue() {
            return false;
        }

        public boolean getNewBooleanValue() {
            return false;
        }

        public byte getOldByteValue() {
            return 0;
        }

        public byte getNewByteValue() {
            return 0;
        }

        public char getOldCharValue() {
            return '\u0000';
        }

        public char getNewCharValue() {
            return '\u0000';
        }

        public double getOldDoubleValue() {
            return 0.0;
        }

        public double getNewDoubleValue() {
            return 0.0;
        }

        public float getOldFloatValue() {
            return 0.0f;
        }

        public float getNewFloatValue() {
            return 0.0f;
        }

        public int getOldIntValue() {
            return 0;
        }

        public int getNewIntValue() {
            return 0;
        }

        public long getOldLongValue() {
            return 0L;
        }

        public long getNewLongValue() {
            return 0L;
        }

        public short getOldShortValue() {
            return 0;
        }

        public short getNewShortValue() {
            return 0;
        }

        public String getOldStringValue() {
            return null;
        }

        public String getNewStringValue() {
            return null;
        }

        public Object getElement() {
            return this.element;
        }

        public boolean isContentRefresh() {
            return this.contentRefresh;
        }

        public boolean isLabelUpdate() {
            return this.labelUpdate;
        }

        public List<Runnable> getRunnables() {
            return this.runnables;
        }

        @Override
        public void run() {
            for (Runnable runnable : this.runnables) {
                runnable.run();
            }
        }
    }
}

