/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.match;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.match.MatchOfContainmentReferenceChangeAdapter;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;

public class MatchOfContainmentReferenceChangeProcessor {
    public void execute(Comparison comp) {
        for (Match rootMatch : comp.getMatches()) {
            this.checkForMatchRelatedToContainmentReferenceChange(rootMatch);
        }
    }

    protected void checkForMatchRelatedToContainmentReferenceChange(Match match) {
        EObject parentMatch = match.eContainer();
        if (parentMatch instanceof Match) {
            EList differences = ((Match)parentMatch).getDifferences();
            for (Diff parentMatchDiff : differences) {
                EObject value;
                if (!EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE.apply((Object)parentMatchDiff) || (value = ((ReferenceChange)parentMatchDiff).getValue()) == null || !value.equals(match.getLeft()) && !value.equals(match.getRight()) && !value.equals(match.getOrigin())) continue;
                match.eAdapters().add((Object)new MatchOfContainmentReferenceChangeAdapter((ReferenceChange)parentMatchDiff));
                break;
            }
        }
        for (Match subMatch : match.getSubmatches()) {
            this.checkForMatchRelatedToContainmentReferenceChange(subMatch);
        }
    }
}

