/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.compare.internal.dmp.LineBasedDiff;
import org.eclipse.emf.compare.internal.dmp.diff_match_patch;

public class ThreeWayTextDiff {
    private final boolean isLeftOrRightUnset;
    private final List<ThreeWayLineDifference> threeWayDifferences;
    private ConflictState conflictState = ConflictState.UNKNOWN;
    private String lineSeparator = "\n";
    private String merged;

    public ThreeWayTextDiff(String origin, String left, String right) {
        this.lineSeparator = this.determineLineSeparator(origin);
        this.isLeftOrRightUnset = origin != null && (left == null || right == null);
        this.threeWayDifferences = this.computeThreeWayDiffs(origin, left, right);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String determineLineSeparator(String string) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                StringReader stringReader;
                block11: {
                    stringReader = new StringReader(this.nullToEmpty(string));
                    int read = 0;
                    finally {
                        if (read == -1) break block11;
                    }
                    read = stringReader.read();
                    char currentChar = (char)read;
                    if (currentChar == '\n' || currentChar == '\r') {
                        String separator = String.valueOf(currentChar);
                        read = stringReader.read();
                        char nextChar = (char)read;
                        if (read != -1 && nextChar != currentChar && (nextChar == '\r' || nextChar == '\n')) {
                            separator = String.valueOf(separator) + nextChar;
                        }
                        return separator;
                    }
                }
                if (stringReader == null) return "\n";
                stringReader.close();
                return "\n";
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "\n";
    }

    private List<ThreeWayLineDifference> computeThreeWayDiffs(String origin, String left, String right) {
        TwoWayTextDiff leftDiffs = new TwoWayTextDiff(origin, left);
        TwoWayTextDiff rightDiffs = new TwoWayTextDiff(origin, right);
        LinkedList<ThreeWayLineDifference> threeWayDiffs = new LinkedList<ThreeWayLineDifference>();
        LinkedList<diff_match_patch.Diff> leftDiffQueue = new LinkedList<diff_match_patch.Diff>(leftDiffs.getDifferences());
        LinkedList<diff_match_patch.Diff> rightDiffQueue = new LinkedList<diff_match_patch.Diff>(rightDiffs.getDifferences());
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (BufferedReader originReader = this.createBufferedReader(this.nullToEmpty(origin));){
                String originLine;
                while ((originLine = originReader.readLine()) != null) {
                    List<diff_match_patch.Diff> leftRange = this.collectDifferenceRange(originLine, leftDiffQueue);
                    List<diff_match_patch.Diff> rightRange = this.collectDifferenceRange(originLine, rightDiffQueue);
                    threeWayDiffs.add(new ThreeWayLineDifference(leftRange, rightRange));
                }
                if (!leftDiffQueue.isEmpty() || !rightDiffQueue.isEmpty()) {
                    threeWayDiffs.add(new ThreeWayLineDifference(leftDiffQueue, rightDiffQueue));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return threeWayDiffs;
    }

    private List<diff_match_patch.Diff> collectDifferenceRange(String originLine, LinkedList<diff_match_patch.Diff> diffQueue) {
        LinkedList<diff_match_patch.Diff> diffs = new LinkedList<diff_match_patch.Diff>();
        diff_match_patch.Diff currentDiff = diffQueue.peek();
        boolean hitEqualsOriginLine = false;
        boolean hitDeleteOriginLine = false;
        while (currentDiff != null && !hitEqualsOriginLine && !hitDeleteOriginLine) {
            hitEqualsOriginLine = this.isEqualOfLine(currentDiff, originLine);
            hitDeleteOriginLine = this.isDeleteOfLine(currentDiff, originLine);
            diffs.add(diffQueue.poll());
            currentDiff = diffQueue.peek();
        }
        while (hitDeleteOriginLine && currentDiff != null && this.isInsert(currentDiff)) {
            diffs.add(diffQueue.poll());
            currentDiff = diffQueue.peek();
        }
        return diffs;
    }

    private boolean isEqualOfLine(diff_match_patch.Diff diff, String line) {
        return diff != null && this.isEqual(diff) && line.equals(diff.text);
    }

    private boolean isDeleteOfLine(diff_match_patch.Diff diff, String line) {
        return diff != null && this.isDelete(diff) && line.equals(diff.text);
    }

    private boolean isEqual(diff_match_patch.Diff diff) {
        return diff != null && diff_match_patch.Operation.EQUAL.equals((Object)diff.operation);
    }

    private boolean isDelete(diff_match_patch.Diff diff) {
        return diff != null && diff_match_patch.Operation.DELETE.equals((Object)diff.operation);
    }

    private boolean isInsert(diff_match_patch.Diff diff) {
        return diff != null && diff_match_patch.Operation.INSERT.equals((Object)diff.operation);
    }

    public boolean isConflicting() {
        if (ConflictState.UNKNOWN.equals((Object)this.conflictState)) {
            this.conflictState = this.computeConflictState();
        }
        return ConflictState.CONFLICTING.equals((Object)this.conflictState);
    }

    private ConflictState computeConflictState() {
        for (ThreeWayLineDifference threeWayDiff : this.threeWayDifferences) {
            if (!threeWayDiff.isConflicting()) continue;
            return ConflictState.CONFLICTING;
        }
        return ConflictState.NOT_CONFLICTING;
    }

    public String getMerged() {
        if (this.merged == null) {
            this.merged = this.computeMerged();
        }
        return this.merged;
    }

    private String computeMerged() {
        StringBuilder mergeBuilder = new StringBuilder();
        for (ThreeWayLineDifference threeWayLineDifference : this.threeWayDifferences) {
            mergeBuilder.append(threeWayLineDifference.getMerged());
        }
        return this.stripTrailingNewLine(this.nullIfUnset(mergeBuilder.toString()));
    }

    private String stripTrailingNewLine(String string) {
        if (string != null && string.endsWith(this.lineSeparator)) {
            return string.substring(0, string.length() - this.lineSeparator.length());
        }
        return string;
    }

    private BufferedReader createBufferedReader(String string) {
        return new BufferedReader(new StringReader(string));
    }

    private String nullIfUnset(String mergeResult) {
        if (mergeResult.length() < 1 && this.isLeftOrRightUnset) {
            return null;
        }
        return mergeResult;
    }

    private String nullToEmpty(String text) {
        if (text == null) {
            return "";
        }
        return text;
    }

    private static enum ConflictState {
        UNKNOWN,
        CONFLICTING,
        NOT_CONFLICTING;

    }

    private class ThreeWayLineDifference {
        private final LinkedList<diff_match_patch.Diff> leftDiffs = new LinkedList();
        private final LinkedList<diff_match_patch.Diff> rightDiffs = new LinkedList();

        ThreeWayLineDifference(List<diff_match_patch.Diff> leftDifferences, List<diff_match_patch.Diff> rightDifferences) {
            this.leftDiffs.addAll(leftDifferences);
            this.rightDiffs.addAll(rightDifferences);
        }

        public boolean isConflicting() {
            return this.isInsertInsertConflict() || this.isDeleteUpdateConflict() || this.isUpdateUpdateConflict();
        }

        private boolean isUpdateUpdateConflict() {
            List<diff_match_patch.Diff> leftInsertsAfterDelete = this.getAllInsertsAfterDelete(this.leftDiffs);
            List<diff_match_patch.Diff> rightsInsertsAfterDelete = this.getAllInsertsAfterDelete(this.rightDiffs);
            return this.containDifferentInserts(leftInsertsAfterDelete, rightsInsertsAfterDelete);
        }

        private boolean isInsertInsertConflict() {
            List<diff_match_patch.Diff> leftInsertsBeforeOriginLine = this.getAllInsertsBeforeEqualsOrDelete(this.leftDiffs);
            List<diff_match_patch.Diff> rightInsertsBeforeOriginLine = this.getAllInsertsBeforeEqualsOrDelete(this.rightDiffs);
            return this.containDifferentInserts(leftInsertsBeforeOriginLine, rightInsertsBeforeOriginLine);
        }

        private List<diff_match_patch.Diff> getAllInsertsBeforeEqualsOrDelete(LinkedList<diff_match_patch.Diff> diffs) {
            LinkedList<diff_match_patch.Diff> inserts = new LinkedList<diff_match_patch.Diff>();
            for (diff_match_patch.Diff diff : diffs) {
                if (ThreeWayTextDiff.this.isEqual(diff) || ThreeWayTextDiff.this.isDelete(diff)) break;
                if (!ThreeWayTextDiff.this.isInsert(diff)) continue;
                inserts.add(diff);
            }
            return inserts;
        }

        private List<diff_match_patch.Diff> getAllInsertsAfterDelete(LinkedList<diff_match_patch.Diff> diffs) {
            LinkedList<diff_match_patch.Diff> inserts = new LinkedList<diff_match_patch.Diff>();
            boolean hitDeleteOrigin = false;
            for (diff_match_patch.Diff diff : diffs) {
                if (hitDeleteOrigin && ThreeWayTextDiff.this.isInsert(diff)) {
                    inserts.add(diff);
                }
                if (!ThreeWayTextDiff.this.isDelete(diff)) continue;
                hitDeleteOrigin = true;
            }
            return inserts;
        }

        private boolean containDifferentInserts(List<diff_match_patch.Diff> leftInserts, List<diff_match_patch.Diff> rightInserts) {
            Iterator<diff_match_patch.Diff> leftDiffIterator = leftInserts.iterator();
            Iterator<diff_match_patch.Diff> rightDiffIterator = rightInserts.iterator();
            while (leftDiffIterator.hasNext() && rightDiffIterator.hasNext()) {
                diff_match_patch.Diff leftDiff = leftDiffIterator.next();
                diff_match_patch.Diff rightDiff = rightDiffIterator.next();
                if (leftDiff.text.equals(rightDiff.text)) continue;
                return true;
            }
            return false;
        }

        private boolean isDeleteUpdateConflict() {
            if ((this.leftDiffs.size() > 1 || this.rightDiffs.size() > 1) && ThreeWayTextDiff.this.isDelete(this.leftDiffs.peek()) && ThreeWayTextDiff.this.isDelete(this.rightDiffs.peek())) {
                Optional<diff_match_patch.Diff> leftInsert = this.getFirstInsert(this.leftDiffs);
                Optional<diff_match_patch.Diff> rightInsert = this.getFirstInsert(this.rightDiffs);
                return leftInsert.isPresent() && !rightInsert.isPresent() || !leftInsert.isPresent() && rightInsert.isPresent();
            }
            return false;
        }

        private Optional<diff_match_patch.Diff> getFirstInsert(LinkedList<diff_match_patch.Diff> diffs) {
            for (diff_match_patch.Diff diff : diffs) {
                if (!ThreeWayTextDiff.this.isInsert(diff)) continue;
                return Optional.of((Object)diff);
            }
            return Optional.absent();
        }

        public String getMerged() {
            StringBuilder stringBuilder = new StringBuilder();
            for (diff_match_patch.Diff diff : this.mergeDifferences()) {
                stringBuilder.append(String.valueOf(diff.text) + ThreeWayTextDiff.this.lineSeparator);
            }
            return stringBuilder.toString();
        }

        private Iterable<diff_match_patch.Diff> mergeDifferences() {
            LinkedList<diff_match_patch.Diff> secondaryDiffs;
            LinkedList<diff_match_patch.Diff> primaryDiffs;
            if (this.isRightPrimaryMergeSide()) {
                primaryDiffs = this.rightDiffs;
                secondaryDiffs = this.leftDiffs;
            } else {
                primaryDiffs = this.leftDiffs;
                secondaryDiffs = this.rightDiffs;
            }
            Iterable filteredPrimaryDiffs = Iterables.filter(primaryDiffs, this.isMergedAsPrimaryDiff(secondaryDiffs));
            Iterable filteredSecondaryDiffs = Iterables.filter(secondaryDiffs, this.isMergedAsSecondaryDiff(primaryDiffs));
            return Iterables.concat((Iterable)filteredPrimaryDiffs, (Iterable)filteredSecondaryDiffs);
        }

        private boolean isRightPrimaryMergeSide() {
            int noOfLeftInsertaions;
            int noOfRightInsertions = this.getAllInsertsBeforeEqualsOrDelete(this.rightDiffs).size();
            return noOfRightInsertions > (noOfLeftInsertaions = this.getAllInsertsBeforeEqualsOrDelete(this.leftDiffs).size());
        }

        private Predicate<diff_match_patch.Diff> isMergedAsSecondaryDiff(final LinkedList<diff_match_patch.Diff> primaryDiffs) {
            return new Predicate<diff_match_patch.Diff>(){

                public boolean apply(diff_match_patch.Diff input) {
                    return !ThreeWayTextDiff.this.isDelete(input) && !ThreeWayLineDifference.this.containsEqualOrOverridingDiff(primaryDiffs, input);
                }
            };
        }

        private Predicate<diff_match_patch.Diff> isMergedAsPrimaryDiff(final LinkedList<diff_match_patch.Diff> secondaryDiffs) {
            return new Predicate<diff_match_patch.Diff>(){

                public boolean apply(diff_match_patch.Diff input) {
                    return !ThreeWayTextDiff.this.isDelete(input) && !ThreeWayLineDifference.this.containsOverridingDiff(secondaryDiffs, input);
                }
            };
        }

        private boolean containsOverridingDiff(Iterable<diff_match_patch.Diff> diffs, diff_match_patch.Diff diff) {
            for (diff_match_patch.Diff currentDiff : diffs) {
                if (!this.isOverridingDiff(diff, currentDiff)) continue;
                return true;
            }
            return false;
        }

        private boolean containsEqualOrOverridingDiff(Iterable<diff_match_patch.Diff> diffs, diff_match_patch.Diff diff) {
            for (diff_match_patch.Diff currentDiff : diffs) {
                if (!currentDiff.equals(diff) && !this.isOverridingDiff(diff, currentDiff)) continue;
                return true;
            }
            return false;
        }

        private boolean isOverridingDiff(diff_match_patch.Diff diff, diff_match_patch.Diff overridingDiff) {
            return ThreeWayTextDiff.this.isEqual(diff) && ThreeWayTextDiff.this.isDelete(overridingDiff) && overridingDiff.text.equals(diff.text);
        }
    }

    private class TwoWayTextDiff {
        private final LineBasedDiff lbDiff = new LineBasedDiff();
        private final LinkedList<diff_match_patch.Diff> diffs;

        TwoWayTextDiff(String origin, String revised) {
            String safeOrigin = ThreeWayTextDiff.this.nullToEmpty(origin);
            String safeRevised = ThreeWayTextDiff.this.nullToEmpty(revised);
            LinkedList<diff_match_patch.Diff> differences = this.lbDiff.computeLineBasedDiff(safeOrigin, safeRevised);
            this.diffs = this.flattenDifferences(differences);
        }

        private LinkedList<diff_match_patch.Diff> flattenDifferences(LinkedList<diff_match_patch.Diff> differences) {
            LinkedList<diff_match_patch.Diff> flattenedDifferences = new LinkedList<diff_match_patch.Diff>();
            for (diff_match_patch.Diff diff : differences) {
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (BufferedReader reader = ThreeWayTextDiff.this.createBufferedReader(diff.text);){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            flattenedDifferences.add(new diff_match_patch.Diff(diff.operation, line));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return flattenedDifferences;
        }

        public List<diff_match_patch.Diff> getDifferences() {
            return Collections.unmodifiableList(this.diffs);
        }
    }
}

