/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.sdk.core.internal.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.common.sdk.core.internal.exported.IEmfFacetProjectBuilder;
import org.eclipse.emf.validation.marker.MarkerUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationValidationBuilder
implements IEmfFacetProjectBuilder,
IResourceDeltaVisitor,
IResourceVisitor {
    public IProject[] build(IncrementalProjectBuilder builder, int kind, Map<?, ?> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(builder);
        } else {
            IResourceDelta delta = builder.getDelta(builder.getProject());
            if (delta == null) {
                this.fullBuild(builder);
            } else {
                this.incrementalBuild(delta);
            }
        }
        return new IProject[0];
    }

    public void clean(IncrementalProjectBuilder builder, IProgressMonitor monitor) throws CoreException {
        builder.getProject().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (CustomizationValidationBuilder.isCustomizationFile(resource)) {
                    resource.deleteMarkers("org.eclipse.emf.validation.problem", true, 2);
                }
                return true;
            }
        });
    }

    private void incrementalBuild(IResourceDelta delta) throws CoreException {
        delta.accept((IResourceDeltaVisitor)this);
    }

    private void fullBuild(IncrementalProjectBuilder builder) throws CoreException {
        builder.getProject().accept((IResourceVisitor)this);
    }

    protected static boolean isCustomizationFile(IResource resource) {
        return resource.getType() == 1 && "custom".equals(resource.getFileExtension());
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (CustomizationValidationBuilder.isCustomizationFile(delta.getResource())) {
            CustomizationValidationBuilder.validate(delta.getResource());
        }
        return true;
    }

    public boolean visit(IResource resource) throws CoreException {
        if ("custom".equals(resource.getFileExtension())) {
            CustomizationValidationBuilder.validate(resource);
        }
        return true;
    }

    protected static void validate(IResource resource) throws CoreException {
        if (resource.exists()) {
            IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
            validator.setOption(IBatchValidator.OPTION_TRACK_RESOURCES, (Object)Boolean.TRUE);
            IStatus multiStatus = validator.validate(CustomizationValidationBuilder.getAllContents(resource));
            MarkerUtil.updateMarkers((IStatus)multiStatus);
        }
    }

    public static List<EObject> getAllContents(IResource resource) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource modelResource = resourceSet.getResource(URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true), true);
        TreeIterator allContents = EcoreUtil.getAllContents((Resource)modelResource, (boolean)true);
        while (allContents.hasNext()) {
            result.add((EObject)allContents.next());
        }
        return result;
    }
}

